<!---
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * This is the "File Uploader" for ColdFusion.
 * Based on connector.cfm by Mark Woods (mark@thickpaddy.com)
--->

<cfparam name="url.type" default="File">
<cfparam name="url.currentFolder" default="/">

<cfinclude template="config.cfm">
<cfinclude template="commands.cfm">

<cfif NOT config.enabled>
	<cfset SendUploadResults(1, '', '', 'This file uploader is disabled. Please check the "editor/filemanager/connectors/cfm/config.cfm" file')>
<cfelse>
	<cfscript>

		userFilesPath = config.userFilesPath;

		if ( userFilesPath eq "" ) { 
			userFilesPath = "/userfiles/"; 
		} 

		// make sure the user files path is correctly formatted
		userFilesPath = replace(userFilesPath, "\", "/", "ALL");
		userFilesPath = replace(userFilesPath, '//', '/', 'ALL');
		if ( right(userFilesPath,1) NEQ "/" ) {
			userFilesPath = userFilesPath & "/";
		}
		if ( left(userFilesPath,1) NEQ "/" ) {
			userFilesPath = "/" & userFilesPath;
		}

		// make sure the current folder is correctly formatted
		url.currentFolder = replace(url.currentFolder, "\", "/", "ALL");
		url.currentFolder = replace(url.currentFolder, '//', '/', 'ALL');
		if ( right(url.currentFolder,1) neq "/" ) {
			url.currentFolder = url.currentFolder & "/";
		}
		if ( left(url.currentFolder,1) neq "/" ) {
			url.currentFolder = "/" & url.currentFolder;
		}

		if (find("/",getBaseTemplatePath())) {
			fs = "/";
		} else {
			fs = "\";
		}

		// Get the base physical path to the web root for this application. The code to determine the path automatically assumes that
		// the "FCKeditor" directory in the http request path is directly off the web root for the application and that it's not a
		// virtual directory or a symbolic link / junction. Use the serverPath config setting to force a physical path if necessary.
		if ( len(config.serverPath) ) {
			serverPath = config.serverPath;

			if ( right(serverPath,1) neq fs ) { 
				serverPath = serverPath & fs; 
			} 
		} else {
			serverPath = replaceNoCase(getBaseTemplatePath(),replace(cgi.script_name,"/",fs,"all"),"") & replace(userFilesPath,"/",fs,"all");
		}

		// map the user files path to a physical directory
		userFilesServerPath = serverPath & url.type & replace(url.currentFolder,"/",fs,"all");

	</cfscript>
	<cfset currentFolderPath = userFilesServerPath>

	<cfset FileUpload(url.type, currentFolderPath)>

</cfif>