/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

/**
 * @fileOverview
 * Ant scripts for auto-generate the testing fort profile file( profile.js ) from the testing cell files.  
 */
importClass( java.io.File );
importClass( java.io.File );
importClass( java.io.FileReader );
importClass( java.io.BufferedReader );
importClass( org.apache.tools.ant.util.FileUtils );

( function()
{
	function echo( msg, file )
	{
		var echo = genProfileProject.createTask( "echo" );
		echo.setEncoding( 'utf-8' );
		echo.setMessage( msg );
		file && echo.setFile( file );
		echo.perform();
	}

	function getFileContent( file )
	{
		return String( FileUtils.readFully( new BufferedReader( new FileReader( file ) ) ) );
	}

	// Modify the followng to define working directories and paths.
	var testsRoot = '../../',
		profileTemplateFileName = 'profile.js.tpl',
		outputProfileFileName = 'profile.js',
		includesWilcard = '**/*.html',
		excludesWilcard = '*,**/_asset/**/*,**/_editor/**/*,**/cktester/**/*';

	// Grouping all the cell files. 
	var fs = project.createDataType( "fileset" );
	fs.setDir( new File( testsRoot ) );
	fs.setIncludes( includesWilcard );
	fs.setExcludes( excludesWilcard );
	var srcFiles = fs.getDirectoryScanner( project ).getIncludedFiles(),
		allCells = "";

	// Processing cell content.
	for ( var i=0; i < srcFiles.length; i++ )
	{
	  // get the values via Java API
	  var dir = fs.getDir( project ),
		  filePath = srcFiles[ i ],
		  file = new File( dir, filePath ),
		  content = getFileContent( file ),
		  tags = [];

		// Grab tags defined inside test html files.
		content.replace( /<meta\s*name=\"tags\"\s*content=\"([^'\"]*?)\"\s*>/gi,
			function( match, g1 ){ tags = g1.split( ',' ); } );

		// Figure out the relative path to CKTester runner.
		var deliminator =  File.separator,
			relativePath = String( file.getPath() ).replace( /\.\w+$/, '' ).split( deliminator );
		relativePath.shift();
		relativePath = relativePath.join( '/' );

		allCells += "\t[ "
			+ "'" + relativePath + "'"	// cell paths
			+ ( tags.length ? ",[ '"+ tags.join( "','" ) + "' ] " : '' )	// cell tags
			+ " ]"
			+ ( ( i == srcFiles.length - 1 ) ? '\n' : ',\n' );
	}
	allCells = '\n[\n' + allCells + ']';

	// Output the cells into the testing profile file.
	var template = getFileContent( new File( testsRoot, profileTemplateFileName ) ),
		result = template.replace( '${cells}', allCells ),
		profileFile = new File( testsRoot, outputProfileFileName );
	echo( result, profileFile );
} )();






