var FCKDragTableHandler = 
{
	"_DragState" : 0,
	"_LeftCell" : null,
	"_RightCell" : null,
	"_OldCursor" : null,
	"_MouseMoveMode" : 0,	// 0 - find candidate cells for resizing, 1 - drag to resize
	"GetWindowPosition" : function( w, node )
	{
		var x = 0 ;
		var y = 0 ;
		var curNode = node ;
		while ( curNode )
		{
			x += curNode.offsetLeft - curNode.scrollLeft ;
			y += curNode.offsetTop - curNode.scrollTop ;
			curNode = curNode.offsetParent ;
		}
		if ( w.scrollX && w.document.documentElement.scrollLeft == 0 
				&& w.document.body.scrollLeft == 0 )
			x -= w.scrollX ;
		if ( w.scrollY && w.document.documentElement.scrollTop == 0 
				&& w.document.body.scrollTop == 0 )
			y -= w.scrollY ;
		return { "x" : x, "y" : y } ;
	},
	"IsInsideNode" : function( w, domNode, pos )
	{
		var myCoords = FCKDragTableHandler.GetWindowPosition( w, domNode ) ; 
		var xMin = myCoords.x ;
		var yMin = myCoords.y ;
		var xMax = parseInt( xMin ) + parseInt( domNode.offsetWidth ) ;
		var yMax = parseInt( yMin ) + parseInt( domNode.offsetHeight ) ;
		if ( pos.x >= xMin && pos.x <= xMax && pos.y >= yMin && pos.y <= yMax )
			return true;
		return false;
	},
	"GetBorderCells" : function( w, tableNode, evt )
	{
		// Enumerate all the cells in the table.
		var cells = [] ;
		for ( var i = 0 ; i < tableNode.rows.length ; i++ )
		{
			var r = tableNode.rows[i] ;
			for ( var j = 0 ; j < r.cells.length ; j++ )
				cells.push( r.cells[j] ) ;
		}

		if ( cells.length < 1 )
			return null ;

		// Get the cells whose right or left border is nearest to the mouse cursor's x coordinate.
		var minRxDist = null ;
		var minLxDist = null ;
		var minYDist = null ;
		var rbCell = null ;
		var lbCell = null ;
		for ( var i = 0 ; i < cells.length ; i++ )
		{
			var pos = FCKDragTableHandler.GetWindowPosition( w, cells[i] ) ;
			var rightX = pos.x + parseInt( cells[i].offsetWidth ) ;
			var rxDist = evt.clientX - rightX ;
			var yDist = evt.clientY - ( pos.y + ( cells[i].offsetHeight /2 ) ) ;
			if ( minRxDist == null || 
					( Math.abs( rxDist ) <= Math.abs( minRxDist ) &&
					  ( minYDist == null || Math.abs( yDist ) < Math.abs( minYDist ) ) ) )
			{
				minRxDist = rxDist ;
				minYDist = yDist ;
				rbCell = cells[i] ;
			}
		}
		minYDist = null ;
		var rowNode = FCKTools.GetElementAscensor( rbCell, "tr" ) ;
		var cellIndex = rbCell.cellIndex + 1 ;
		if ( cellIndex >= rowNode.cells.length )
			return null ;
		lbCell = rowNode.cells.item( cellIndex ) ;

		// Abort if too far from the border.
		if ( minLxDist < 0 && minRxDist < 0 && minLxDist < -3 )
			return null ; 
		if ( minLxDist > 0 && minRxDist > 0 && minRxDist > 3 )
			return null ;

		return { "leftCell" : lbCell, "rightCell" : rbCell } ;
	},
	"MouseDownListener" : function( FCK, evt )
	{
		if ( FCKDragTableHandler._LeftCell )
			FCKDragTableHandler._MouseMoveMode = 1 ;
	},
	"MouseUpListener" : function( FCK, evt )
	{
		FCKDragTableHandler._MouseMoveMode = 0 ;
	},
	"MouseMoveListener" : function( FCK, evt )
	{
		if ( FCKDragTableHandler._MouseMoveMode == 0 )
			return FCKDragTableHandler._MouseFindHandler( FCK, evt ) ;
		else
			return FCKDragTableHandler._MouseDragHandler( FCK, evt ) ;
	},
	"_MouseFindHandler" : function( FCK, evt )
	{
		var node = evt.srcElement || evt.originalTarget ;
		try
		{
			if ( ! node || node.nodeType != 1 )
			{
				FCK.EditorDocument.body.style.cursor = FCK.EditorDocument._OldCursor ;
				FCK.EditorDocument._OldCursor = null ;
				return ;
			}
		}
		catch ( e )
		{
			FCK.EditorDocument.body.style.cursor = FCK.EditorDocument._OldCursor ;
			FCK.EditorDocument._OldCursor = null ;
			return ;
		}
		var tagName = node.tagName.toLowerCase() ;
		if ( tagName != "table" && tagName != "td" && tagName != "th" )
		{
			FCK.EditorDocument.body.style.cursor = FCK.EditorDocument._OldCursor ;
			FCK.EditorDocument._OldCursor = null ;
			return ;
		}
		node = FCKTools.GetElementAscensor( node, "table" ) ;
		var cellTuple = FCKDragTableHandler.GetBorderCells( FCK.EditorWindow, node, evt ) ;

		if ( cellTuple == null )
		{
			if ( FCKDragTableHandler._LeftCell )
				FCKDragTableHandler._LeftCell = FCKDragTableHandler._RightCell = null ;
			FCK.EditorDocument.body.style.cursor = FCK.EditorDocument._OldCursor ;
			FCK.EditorDocument._OldCursor = null ;
		}
		else
		{
			FCKDragTableHandler._OldCursor = FCK.EditorDocument.body.style.cursor ;
			FCK.EditorDocument.body.style.cursor = "e-resize" ;
			FCKDragTableHandler._LeftCell = cellTuple["leftCell"] ;
			FCKDragTableHandler._RightCell = cellTuple["rightCell"] ;
		}
	},
	"_MouseDragHandler" : function( FCK, evt )
	{
	}
};

FCK.Events.AttachEvent( "OnMouseDown", FCKDragTableHandler.MouseDownListener ) ;
FCK.Events.AttachEvent( "OnMouseUp", FCKDragTableHandler.MouseUpListener ) ;
FCK.Events.AttachEvent( "OnMouseMove", FCKDragTableHandler.MouseMoveListener ) ;
