var FCKDragTableHandler = 
{
	"_DragState" : 0,
	"_LeftCell" : null,
	"_RightCell" : null,
	"_MouseMoveMode" : 0,	// 0 - find candidate cells for resizing, 1 - drag to resize
	"_ResizeBar" : null,
	"_OriginalX" : null,
	"_GetWindowScrollX" : function( w )
	{
		var scrollX = 0 ;
		if ( w.document.documentElement && w.document.documentElement.scrollLeft ) 
			scrollX = w.document.documentElement.scrollLeft ;
		else if ( w.document.body && w.document.body.scrollLeft )
			scrollX = w.document.body.scrollLeft ;
		else if ( w.scrollX )
			scrollX = w.scrollX ;
		return scrollX ;
	},
	"_GetWindowScrollY" : function( w )
	{
		var scrollY = 0 ;
		if ( w.document.documentElement && w.document.documentElement.scrollTop )
			scrollY = w.document.documentElement.scrollTop ;
		else if ( w.document.body && w.document.body.scrollTop )
			scrollY = w.document.body.scrollTop ;
		else if ( w.scrollY )
			scrollY = w.scrollY ;
		return scrollY ;
	},
	"_GetDocumentPosition" : function( w, node )
	{
		var x = 0 ;
		var y = 0 ;
		var curNode = node ;
		while ( curNode && curNode != w.document.body )
		{
			x += curNode.offsetLeft - curNode.scrollLeft ;
			y += curNode.offsetTop - curNode.scrollTop ;
			curNode = curNode.offsetParent ;
		}
		return { "x" : x, "y" : y } ;
	},
	"_GetWindowPosition" : function( w, node )
	{
		var pos = FCKDragTableHandler._GetDocumentPosition( w, node ) ;
		pos.x -= FCKDragTableHandler._GetWindowScrollX( w ) ;
		pos.y -= FCKDragTableHandler._GetWindowScrollY( w ) ;
		return pos ;
	},
	"_IsInsideNode" : function( w, domNode, pos )
	{
		var myCoords = FCKDragTableHandler._GetWindowPosition( w, domNode ) ; 
		var xMin = myCoords.x ;
		var yMin = myCoords.y ;
		var xMax = parseInt( xMin ) + parseInt( domNode.offsetWidth ) ;
		var yMax = parseInt( yMin ) + parseInt( domNode.offsetHeight ) ;
		if ( pos.x >= xMin && pos.x <= xMax && pos.y >= yMin && pos.y <= yMax )
			return true;
		return false;
	},
	"_GetBorderCells" : function( w, tableNode, mouse )
	{
		// Enumerate all the cells in the table.
		var cells = [] ;
		for ( var i = 0 ; i < tableNode.rows.length ; i++ )
		{
			var r = tableNode.rows[i] ;
			for ( var j = 0 ; j < r.cells.length ; j++ )
				cells.push( r.cells[j] ) ;
		}

		if ( cells.length < 1 )
			return null ;

		// Get the cells whose right or left border is nearest to the mouse cursor's x coordinate.
		var minRxDist = null ;
		var lxDist = null ;
		var minYDist = null ;
		var rbCell = null ;
		var lbCell = null ;
		for ( var i = 0 ; i < cells.length ; i++ )
		{
			var pos = FCKDragTableHandler._GetWindowPosition( w, cells[i] ) ;
			var rightX = pos.x + parseInt( cells[i].clientWidth ) ;
			var rxDist = mouse.x - rightX ;
			var yDist = mouse.y - ( pos.y + ( cells[i].clientHeight / 2 ) ) ;
			if ( minRxDist == null || 
					( Math.abs( rxDist ) <= Math.abs( minRxDist ) &&
					  ( minYDist == null || Math.abs( yDist ) < Math.abs( minYDist ) ) ) )
			{
				minRxDist = rxDist ;
				minYDist = yDist ;
				rbCell = cells[i] ;
			}
		}
		var rowNode = FCKTools.GetElementAscensor( rbCell, "tr" ) ;
		var cellIndex = rbCell.cellIndex + 1 ;
		if ( cellIndex >= rowNode.cells.length )
			return null ;
		lbCell = rowNode.cells.item( cellIndex ) ;

		// Abort if too far from the border.
		lxDist = mouse.x - FCKDragTableHandler._GetWindowPosition( w, lbCell ).x ;
		if ( lxDist < 0 && minRxDist < 0 && minRxDist < -2 )
			return null ; 
		if ( lxDist > 0 && minRxDist > 0 && lxDist > 3 )
			return null ;

		return { "leftCell" : rbCell, "rightCell" : lbCell } ;
	},
	"_ResizeBarMouseDownListener" : function( evt )
	{
		if ( ! evt )
			evt = window.event ;
		if ( FCKDragTableHandler._LeftCell )
			FCKDragTableHandler._MouseMoveMode = 1 ;
		if ( FCKBrowserInfo.IsIE )
			FCKDragTableHandler._ResizeBar.filters.item("DXImageTransform.Microsoft.Alpha").opacity = 50 ;
		else
			FCKDragTableHandler._ResizeBar.style.opacity = 0.5 ;
		FCKDragTableHandler._OriginalX = evt.clientX ;
	},
	"_ResizeBarMouseUpListener" : function( evt )
	{
		if ( ! evt )
			evt = window.event ;
		FCKDragTableHandler._MouseMoveMode = 0 ;
		FCKDragTableHandler._HideResizeBar() ;
		
		if ( ! FCKDragTableHandler._LeftCell )
			return ;
		
		// First, get the mouse coordiantes relative to the outer window, and calculate the delta value.
		var mouse = { "x" : evt.clientX, "y" : evt.clientY } ;
		var mouseNode = evt.srcElement || evt.originalTarget ;
		var mouseDocument = mouseNode.ownerDocument ;
		if ( mouseDocument == FCK.EditorDocument )
		{
			var offset = FCKDragTableHandler._GetDocumentPosition( window, FCK.EditingArea.IFrame ) ;
			mouse.x += offset.x ;
			mouse.y += offset.y ;
		}
		var deltaX = mouse.x - FCKDragTableHandler._OriginalX ;

		// Then, build an array of current column width values.
		// This algorithm can be very slow if the cells have insane colSpan values. (e.g. colSpan=1000).
		var table = FCKTools.GetElementAscensor( FCKDragTableHandler._LeftCell, "table" ) ;
		var colArray = [] ;
		for ( var r = 0 ; r < table.rows.length ; r++ )
		{
			var colIndex = 0 ;
			var row = table.rows.item( r ) ;
			for ( var c = 0 ; c < row.cells.length ; c++ )
			{
				var cell = row.cells.item( c ) ;
				var width = FCKDragTableHandler._GetCellWidth( table, cell ) ;
				var colSpan = parseInt( cell.colSpan ) ;
				if ( colSpan != colSpan )
					colSpan = 1 ;
				if ( colArray.length < colIndex + colSpan )
				{
					for ( var i = 0 ; i < colSpan ; i++ )
						colArray.push( { "width" : width / colSpan, "colSpan" : colSpan } ) ;
				}
				else
				{
					for ( var i = colIndex ; i < colIndex + colSpan ; i++ )
					{
						var guessItem = colArray[i] ;
						if ( guessItem.colSpan > colSpan )
						{
							guessItem.width = width / colSpan ;
							guessItem.colSpan = colSpan ;
						}
					}
				}
				colIndex += colSpan ;
			}
		}

		// Find out the equivalent column index of the two cells selected for resizing.
		var row = FCKTools.GetElementAscensor( FCKDragTableHandler._LeftCell, "tr" ) ;
		var colIndex = 0 ;
		for ( var i = 0 ; i <= FCKDragTableHandler._LeftCell.cellIndex ; i++ )
		{
			var colSpan = parseInt( row.cells.item( i ).colSpan ) ;
			if ( colSpan != colSpan )
				colSpan = 1 ;
			colIndex += colSpan ;
		}

		// Note that colIndex must be at least 1 here, so it's safe to subtract 1 from it.
		colIndex-- ;

		// Modify the widths in the colArray according to the mouse coordinate delta value.
		colArray[colIndex].width += deltaX ;
		colArray[colIndex + 1].width -= deltaX ;

		// Clear all cell widths, delete all <col> elements from the table.
		for ( var r = 0 ; r < table.rows.length ; r++ )
		{
			var row = table.rows.item( r ) ;
			for ( var c = 0 ; c < row.cells.length ; c++ )
			{
				var cell = row.cells.item( c ) ;
				cell.width = "" ;
				cell.style.width = "" ;
			}
		}
		var colElements = table.getElementsByTagName( "col" ) ;
		for ( var i = colElements.length - 1 ; i >= 0 ; i-- )
			colElements[i].parentNode.removeChild( colElements[i] ) ;

		// Set new cell widths.
		for ( var r = 0 ; r < table.rows.length ; r++ )
		{
			var row = table.rows.item( r ) ;
			var colIndex = 0 ;
			for ( var c = 0 ; c < row.cells.length ; c++ )
			{
				var cell = row.cells.item( c ) ;
				var colSpan = parseInt( cell.colSpan ) ;
				if ( colSpan != colSpan )
					colSpan = 1 ;
				var cellWidth = 0 ;
				for ( var i = colIndex ; i < colIndex + colSpan ; i++ )
					cellWidth += colArray[i].width ;
				cell.width = cellWidth ;
				colIndex += colSpan ;
			}
		}
	},
	"_ResizeBarMouseMoveListener" : function( evt )
	{
		if ( ! evt )
			evt = window.event ;		
		if ( FCKDragTableHandler._MouseMoveMode == 0 )
			return FCKDragTableHandler._MouseFindHandler( FCK, evt ) ;
		else
			return FCKDragTableHandler._MouseDragHandler( FCK, evt ) ;
	},
	// Calculate the padding of a table cell.
	// It returns the value of paddingLeft + paddingRight of a table cell.
	// This function is used, in part, to calculate the width parameter that should be used for setting cell widths.
	// The equation in question is clientWidth = paddingLeft + paddingRight + width.
	// So that width = clientWidth - paddingLeft - paddingRight.
	// The return value of this function must be pixel accurate acorss all supported browsers, so be careful if you need to modify it.
	"_GetCellPadding" : function( table, cell )
	{
		var attrGuess = parseInt( table.cellPadding ) * 2 ;
		var cssGuess = null ;
		if ( typeof( window.getComputedStyle ) == "function" )
		{
			var styleObj = window.getComputedStyle( cell, null ) ;
			cssGuess = parseInt( styleObj.getPropertyValue( "padding-left" ) ) + 
				parseInt( styleObj.getPropertyValue( "padding-right" ) ) ;
		}
		else
			cssGuess = parseInt( cell.currentStyle.paddingLeft ) + parseInt (cell.currentStyle.paddingRight ) ;

		var cssRuntime = cell.style.padding ;
		if ( parseInt( cssRuntime ) == parseInt( cssRuntime ) )
			cssGuess = parseInt( cssRuntime ) * 2 ;
		else
		{
			cssRuntime = cell.style.paddingLeft ;
			if ( parseInt( cssRuntime ) == parseInt( cssRuntime ) )
				cssGuess = parseInt( cssRuntime ) ;
			cssRuntime = cell.style.paddingRight ;
			if ( parseInt( cssRuntime ) == parseInt( cssRuntime ) )
				cssGuess += parseInt( cssRuntime ) ;
		}

		attrGuess = parseInt( attrGuess ) ;
		cssGuess = parseInt( cssGuess ) ;
		if ( attrGuess != attrGuess )
			attrGuess = 0 ;
		if ( cssGuess != cssGuess )
			cssGuess = 0 ;
		return Math.max( attrGuess, cssGuess ) ;
	},
	// Calculate the real width of the table cell.
	// The real width of the table cell is the pixel width that you can set to the width attribute of the table cell and after
	// that, the table cell should be of exactly the same width as before.
	// The real width of a table cell can be calculated as:
	// width = clientWidth - paddingLeft - paddingRight.
	"_GetCellWidth" : function( table, cell )
	{
		var clientWidth = parseInt( cell.clientWidth ) ;
		if ( clientWidth != clientWidth )		// NaN possible? lets just be safe...
			clientWidth = 0 ;
		return clientWidth - FCKDragTableHandler._GetCellPadding( table, cell ) ;
	},
	"MouseMoveListener" : function( FCK, evt )
	{
		if ( FCKDragTableHandler._MouseMoveMode == 0 )
			return FCKDragTableHandler._MouseFindHandler( FCK, evt ) ;
		else
			return FCKDragTableHandler._MouseDragHandler( FCK, evt ) ;
	},
	"_MouseFindHandler" : function( FCK, evt )
	{
		var node = evt.srcElement || evt.originalTarget ;
		try
		{
			if ( ! node || node.nodeType != 1 )
			{
				FCKDragTableHandler._HideResizeBar() ;
				return ;
			}
		}
		catch ( e )
		{
			FCKDragTableHandler._HideResizeBar() ;
			return ;
		}
		
		// Since this function might be called from the editing area iframe or the outer fckeditor iframe,
		// the mouse point coordinates from evt.clientX/Y can have different reference points.
		// We need to resolve the mouse pointer position relative to the editing area iframe.
		var mouseX = evt.clientX ;
		var mouseY = evt.clientY ;
		if ( node.ownerDocument == document )
		{
			var offset = FCKDragTableHandler._GetDocumentPosition( window, FCK.EditingArea.IFrame ) ;
			mouseX -= offset.x ;
			mouseY -= offset.y ;
		}


		if ( FCKDragTableHandler._ResizeBar && FCKDragTableHandler._LeftCell )
		{
			var leftPos = FCKDragTableHandler._GetWindowPosition( FCK.EditorWindow, FCKDragTableHandler._LeftCell ) ;
			var rightPos = FCKDragTableHandler._GetWindowPosition( FCK.EditorWindow, FCKDragTableHandler._RightCell ) ; 
			var rxDist = mouseX - ( leftPos.x + FCKDragTableHandler._LeftCell.clientWidth ) ;
			var lxDist = mouseX - rightPos.x ;
			var inRangeFlag = false ;
			if ( lxDist >= 0 && rxDist <= 0 )
				inRangeFlag = true ;
			else if ( rxDist > 0 && lxDist <= 3 )
				inRangeFlag = true ;
			else if ( lxDist < 0 && rxDist >= -2 )
				inRangeFlag = true ;
			if ( inRangeFlag )
			{
				FCKDragTableHandler._ShowResizeBar( FCK.EditorWindow, 
					FCKTools.GetElementAscensor( FCKDragTableHandler._LeftCell, "table" ),
					{ "x" : mouseX, "y" : mouseY } ) ;
				return ;
			}
		}

		var tagName = node.tagName.toLowerCase() ;
		if ( tagName != "table" && tagName != "td" && tagName != "th" )
		{
			if ( FCKDragTableHandler._LeftCell )
				FCKDragTableHandler._LeftCell = FCKDragTableHandler._RightCell = null ;
			FCKDragTableHandler._HideResizeBar() ;
			return ;
		}
		node = FCKTools.GetElementAscensor( node, "table" ) ;
		var cellTuple = FCKDragTableHandler._GetBorderCells( FCK.EditorWindow, node, { "x" : mouseX, "y" : mouseY } ) ;

		if ( cellTuple == null )
		{
			if ( FCKDragTableHandler._LeftCell )
				FCKDragTableHandler._LeftCell = FCKDragTableHandler._RightCell = null ;
			FCKDragTableHandler._HideResizeBar() ;
		}
		else
		{
			FCKDragTableHandler._LeftCell = cellTuple["leftCell"] ;
			FCKDragTableHandler._RightCell = cellTuple["rightCell"] ;
			FCKDragTableHandler._ShowResizeBar( FCK.EditorWindow, 
					FCKTools.GetElementAscensor( FCKDragTableHandler._LeftCell, "table" ),
					{ "x" : mouseX, "y" : mouseY } ) ;
		}
	},
	"_MouseDragHandler" : function( FCK, evt )
	{
		var mouse = { "x" : evt.clientX, "y" : evt.clientY } ;

		// Check if the mouse cursor is still inside the table's area.
		var table = FCKTools.GetElementAscensor( FCKDragTableHandler._LeftCell, "table" );
		var offset = FCKDragTableHandler._GetDocumentPosition( window, FCK.EditingArea.IFrame ) ;
		var innerMouse = { "x" : mouse.x - offset.x, "y" : mouse.y - offset.y } ;
		if ( ! FCKDragTableHandler._IsInsideNode( FCK.EditorWindow, table, innerMouse ) ) 
		{
			FCKDragTableHandler._MouseMoveMode = 0 ;
			FCKDragTableHandler._HideResizeBar() ;
			return ;
		}

		var docX = mouse.x + FCKDragTableHandler._GetWindowScrollX( window ) ;
		FCKDragTableHandler._ResizeBar.style.left = ( docX - FCKDragTableHandler._ResizeBar.offsetWidth / 2 ) + "px" ;
	},
	"_ShowResizeBar" : function( w, table, mouse )
	{
		if ( FCKDragTableHandler._ResizeBar == null )
		{
			FCKDragTableHandler._ResizeBar = document.createElement( "div" ) ;
			var paddingBar = FCKDragTableHandler._ResizeBar ;
			paddingBar.style.position = "absolute" ;
			paddingBar.style.cursor = "e-resize" ;
			if ( FCKBrowserInfo.IsIE )
				paddingBar.style.filter = "progid:DXImageTransform.Microsoft.Alpha(opacity=10,enabled=true)" ;
			else
				paddingBar.style.opacity = 0.10 ;
			document.body.appendChild( paddingBar ) ;
			FCKTools.AddEventListener( paddingBar, "mousemove", FCKDragTableHandler._ResizeBarMouseMoveListener ) ;
			FCKTools.AddEventListener( paddingBar, "mousedown", FCKDragTableHandler._ResizeBarMouseDownListener ) ;
			FCKTools.AddEventListener( document, "mouseup", FCKDragTableHandler._ResizeBarMouseUpListener ) ;
			FCKTools.AddEventListener( FCK.EditorDocument, "mouseup", FCKDragTableHandler._ResizeBarMouseUpListener ) ;

			// IE doesn't let the tranparent part of the padding block to receive mouse events unless there's something inside.
			// So we need to create a spacer image to fill the block up.
			var filler = document.createElement( "img" ) ;
			filler.border = 0 ;
			filler.src = FCKConfig.EditorPath + "/editor/images/spacer.gif" ;
			filler.style.position = "absolute" ;
			paddingBar.appendChild( filler ) ;

			// Disable drag and drop, and selection for the filler image.
			var disabledListener = function( evt )
			{
				if ( ! evt )
					evt = window.event ;
				if ( evt.preventDefault )
					evt.preventDefault() ;
				else
					evt.returnValue = false ;
			}
			FCKTools.AddEventListener( filler, "dragstart", disabledListener ) ;
			FCKTools.AddEventListener( filler, "selectstart", disabledListener ) ;
		}

		var paddingBar = FCKDragTableHandler._ResizeBar ;
		if ( FCKBrowserInfo.IsIE )
			paddingBar.filters.item("DXImageTransform.Microsoft.Alpha").opacity = 10 ;
		else
			paddingBar.style.opacity = 0.1 ;
		var offset = FCKDragTableHandler._GetDocumentPosition( window, FCK.EditingArea.IFrame ) ;
		paddingBar.style.top = ( offset.y + FCKDragTableHandler._GetWindowPosition( w, table ).y ) + "px" ;
		paddingBar.style.height = table.offsetHeight + "px" ;
		var bw = parseInt( table.border ) ;
		if ( bw != bw )
			bw = 0 ;
		var cs = parseInt( table.cellSpacing ) ;
		if ( cs != cs )
			cs = 0 ;
		var barWidth = Math.max( bw+100, cs+100 ) ;
		paddingBar.style.width = barWidth + "px" ;
		paddingBar.style.left = ( offset.x + mouse.x + FCKDragTableHandler._GetWindowScrollX( w ) - barWidth / 2 ) +  "px" ;
		var filler = paddingBar.getElementsByTagName( "img" )[0] ;
		filler.style.width = paddingBar.offsetWidth + "px" ;
		filler.style.height = paddingBar.offsetHeight + "px" ;

		barWidth = Math.max( bw, cs, 3 ) ;
		var visibleBar = null ;
		if ( paddingBar.getElementsByTagName( "div" ).length < 1 )
		{
			visibleBar = document.createElement( "div" ) ;
			paddingBar.appendChild( visibleBar ) ;
		}
		else
			visibleBar = paddingBar.getElementsByTagName( "div" )[0] ;
		visibleBar.style.position = "absolute" ;
		visibleBar.style.backgroundColor = "blue" ;
		visibleBar.style.width = barWidth + "px" ;
		visibleBar.style.height = table.offsetHeight + "px" ;
		visibleBar.style.left = "50px" ;
		visibleBar.style.top = "0px" ;
	},
	"_HideResizeBar" : function()
	{
		if ( FCKDragTableHandler._ResizeBar )
		{
			// IE bug: display : none does not hide the resize bar for some reason.
			// so set the position to somewhere invisible.
			FCKDragTableHandler._ResizeBar.style.top = "-100000px" ;
			FCKDragTableHandler._ResizeBar.style.left = "-100000px" ;
		}
	}
};

FCK.Events.AttachEvent( "OnMouseMove", FCKDragTableHandler.MouseMoveListener ) ;
