/*
Copyright (c) 2003-2010, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/


// Extend YUI Lang to support function interception.
YAHOO.lang.intercept = function( originalFunction, functionBuilder )
{
	return functionBuilder( originalFunction );
};

// Extend YUI TestRunner to support 'wait'/'resume' in during 'setUp' of TestSuite/TestCase.
( function()
{
	function getWaitInterceptor( continuation )
	{
		return function ( original )
		{
			var fn = continuation;
			return function()
			{
				var orgFn = original;
				try
				{
					orgFn.apply( this, arguments );
				}catch( thrown )
				{
					if ( thrown instanceof YAHOO.tool.TestCase.Wait )
					{
						this.continuation = fn;
					}
					else
						throw thrown;
				}
			};
		}
	}

	var runner = YAHOO.tool.TestRunner;

	// Borrow 'wait' from YAHOO.tool.TestCase.
	YAHOO.lang.augment( YAHOO.tool.TestSuite, YAHOO.tool.TestCase, 'wait' );

	// Resume the continuation of setUp on 'resumeSetup()'.
	YAHOO.tool.TestSuite.prototype.resumeSetup = YAHOO.tool.TestCase.prototype.resumeSetup =
	function( )
	{
		runner.continuation.call( runner );
		delete runner.continuation;
	};

	// Pause the test suite setup on any wait() and it's enough to continue by re-calling '_run'.
	runner._run = YAHOO.lang.intercept( runner._run , getWaitInterceptor( function()
	{
		runner._run();
	} ) );

	// Pause the test case setup on any wait(), and continue with '_resumeTest( testFragment )'.
	runner._runTest = YAHOO.lang.intercept( runner._runTest , getWaitInterceptor( function()
	{
		var node = this._cur,
			testName /*:String*/ = node.testObject,
			testCase /*:YAHOO.tool.TestCase*/ = node.parent.testObject,
			test /*:Function*/ = testCase[testName];

		this._resumeTest( test );
	} ) );
} )();

// Extending YUI TestCase functionality.
( function()
{
	// Transform an array of values into object keys with the same value.
	YAHOO.lang.keysToObject = function( array , value )
	{
		var obj = {};
		for( var i = 0 ; i < array.length ; i++ )
		{
			obj[ array[ i ] ] = value;
		}
		return i ? obj : null;
	};

	var original = YAHOO.tool.TestCase;

	// Override the original constructor to wave in template processing logics.
	YAHOO.tool.TestCase = function( template )
	{
		// Construct the '_should' instructions object from any methods
		// prefix by 'should'.
		var nonInstructions = [ '_should', 'name', 'setUp', 'tearDown', /^test/ ],
			should = template._should || ( template._should = {} ),
			match,
			instruction;
		for ( var item in template )
		{
			if ( match = item.match( /^should(.*)/ ) )
			{
				instruction = match[ 1 ];
				should[ instruction.charAt( 0 ).toLowerCase()
					+ instruction.substr( 1 ) ] = YAHOO.lang.keysToObject( template[ item ], true );
				delete template[ item ];
			}
		}

		// Ignore all tests from the template other than the one specified by 'shouldIgnoreAllBut' (#4242).
		var preserves;
		if( ( preserves = template._should.ignoreAllBut ) )
		{
			delete template._should.ignoreAllBut;
			var ignores = template._should.ignore = {}, match, test;
			for ( test in template )
				if ( ( match = test.match( /^test.*/ ) ) && !( match in preserves ) )
					ignores[ match ] = true;
		}

		return original.call( this, template );
	};
	YAHOO.tool.TestCase.prototype = original.prototype;
	YAHOO.tool.TestCase.Wait = original.Wait;

	// Copy the whole YAHOO.tool.TestRuner._resumeTest codes here just to modify it for
	// supporting optional error catching by instruction 'shouldThrows' (#4242).
	YAHOO.tool.TestRunner._resumeTest = function (segment /*:Function*/) /*:Void*/
	{

            //get relevant information
            var node /*:TestNode*/ = this._cur;
            var testName /*:String*/ = node.testObject;
            var testCase /*:YAHOO.tool.TestCase*/ = node.parent.testObject;

            //cancel other waits if available
            if (testCase.__yui_wait){
                clearTimeout(testCase.__yui_wait);
                delete testCase.__yui_wait;
            }

            //get the "should" test cases
            var shouldFail /*:Object*/ = (testCase._should.fail || {})[testName];
            var shouldError /*:Object*/ = (testCase._should.error || {})[testName];
			var shouldThrow /*:Object*/ = (testCase._should.throws || {})[testName];

            //variable to hold whether or not the test failed
            var failed /*:Boolean*/ = false;
            var error /*:Error*/ = null;

			var _resumeTestResult = function ( evt )
			{
				if( evt )
					YAHOO.util.Event.removeListener( window, "error", arguments.callee );
				//fireEvent appropriate event
				if (failed) {
					this.fireEvent(this.TEST_FAIL_EVENT, { testCase: testCase, testName: testName, error: error });
				} else {
					this.fireEvent(this.TEST_PASS_EVENT, { testCase: testCase, testName: testName });
				}

				//run the tear down
				testCase.tearDown();

				//update results
				node.parent.results[testName] = {
					result: failed ? "fail" : "pass",
					message: error ? error.getMessage() : "Test passed",
					type: "test",
					name: testName
				};

				if (failed){
					node.parent.results.failed++;
				} else {
					node.parent.results.passed++;
				}
				node.parent.results.total++;

				//set timeout not supported in all environments
				if (typeof setTimeout != "undefined"){
					setTimeout(function(){
						YAHOO.tool.TestRunner._run();
					}, 0);
				} else {
					this._run();
				}

			};

			//try the test
            try {

                //run the test
                segment.apply(testCase);

                //if it should fail, and it got here, then it's a fail because it didn't
                if (shouldFail){
                    error = new YAHOO.util.ShouldFail();
                    failed = true;
                } else if (shouldError){
                    error = new YAHOO.util.ShouldError();
                    failed = true;
                }

            } catch (thrown /*:Error*/){
                if (thrown instanceof YAHOO.tool.TestCase.Wait){

                    if (YAHOO.lang.isFunction(thrown.segment)){
                        if (YAHOO.lang.isNumber(thrown.delay)){

                            //some environments don't support setTimeout
                            if (typeof setTimeout != "undefined"){
                                testCase.__yui_wait = setTimeout(function(){
                                    YAHOO.tool.TestRunner._resumeTest(thrown.segment);
                                }, thrown.delay);
                            } else {
                                throw new Error("Asynchronous tests not supported in this environment.");
                            }
                        }
                    }

                    return;

				}
				else if (thrown instanceof YAHOO.util.AssertionError) {
						if (!shouldFail){
							error = thrown;
							failed = true;
						}
					} else {
						//first check to see if it should error
						if (!shouldError) {
							error = new YAHOO.util.UnexpectedError(thrown);
							failed = true;
						} else {
							//check to see what type of data we have
							if (YAHOO.lang.isString(shouldError)){

								//if it's a string, check the error message
								if (thrown.message != shouldError){
									error = new YAHOO.util.UnexpectedError(thrown);
									failed = true;
								}
							} else if (YAHOO.lang.isFunction(shouldError)){

								//if it's a function, see if the error is an instance of it
								if (!(thrown instanceof shouldError)){
									error = new YAHOO.util.UnexpectedError(thrown);
									failed = true;
								}

							} else if (YAHOO.lang.isObject(shouldError)){

								//if it's an object, check the instance and message
								if (!(thrown instanceof shouldError.constructor) ||
										thrown.message != shouldError.message){
									error = new YAHOO.util.UnexpectedError(thrown);
									failed = true;
								}

							}

						}
					}

	            if ( shouldThrow )
	            {
		            YAHOO.util.Event.addListener( window, 'error', _resumeTestResult, this, true );
		            throw thrown;
	            }
	            else
	            {
		            _resumeTestResult.call( this );
		            return;
	            }
            }

			_resumeTestResult.call( this );

        };
} )();

(function()
{
	var createLogger = function()
	{
		document.body.appendChild( document.createElement( 'div' ) ).id = 'testLogger';
	};

	var outputResult = function( text )
	{
		var div = document.getElementById('testLogger').appendChild( document.createElement( 'div' ) );
		div.className = 'testEntry';
		div.innerHTML = text;
	};

	var runner = YAHOO.tool.TestRunner;
	// Report runner status to cell.
	if ( CKTESTER.cell )
	{
		runner.subscribe( runner.TEST_CASE_BEGIN_EVENT, CKTESTER.cell.start );
		runner.subscribe( runner.TEST_CASE_COMPLETE_EVENT, CKTESTER.cell.complete );
	}

	var htmlEncode = function( data )
	{
		if ( typeof data != 'string' )
			return data;

		return data.replace(
			/&/g, '&amp;' ).replace(
			/</g, '&lt;' ).replace(
			/>/g, '&gt;' );
	};

	window.onload = function()
	{
		createLogger();

		var handleTestResult = function( data )
		{
			switch( data.type )
			{
				case runner.TEST_FAIL_EVENT:

					var expected = data.error.expected;
					if ( expected && expected.nodeType )
						expected += ' (' + ( expected.nodeType == 1 ? expected.nodeName : expected.nodeValue ) + ')';

					var actual = data.error.actual;
					if ( actual && actual.nodeType )
						actual += ' (' + ( actual.nodeType == 1 ? actual.nodeName : actual.nodeValue ) + ')';

					outputResult(
						'<span class="testFail">FAIL</span> Test named "' + data.testName +
						'" failed with message: "' + htmlEncode( data.error.message ) +
						'".<div>Expected:</div><pre>' + htmlEncode( expected ) +
						'<br></pre><div>Actual:</div><pre>' + htmlEncode( actual ) + '<br></pre>' );
					break;
				case runner.TEST_PASS_EVENT:
					outputResult( '<span class="testPass">PASS</span> Test named "' + data.testName + '" passed.' );
					break;
				case runner.TEST_IGNORE_EVENT:
					outputResult( '<span class="testIgnore">IGNORE</span> Test named "' + data.testName + '" was ignored.' );
					break;
			}
		};

		runner.subscribe(runner.TEST_FAIL_EVENT, handleTestResult);
		runner.subscribe(runner.TEST_IGNORE_EVENT, handleTestResult);
		runner.subscribe(runner.TEST_PASS_EVENT, handleTestResult);
		// Whether control the runner manually instead of running on window onload.
		!runner.defer && runner.run();
	};
})();
