﻿/* @Packager.Header
<FileDescription>
	Class for working with a selection range, much like the W3C DOM Range, but
	it is not intented to be an implementation of the W3C interface.
</FileDescription>
<Author name="Frederico Caldeira Knabben" email="www.fckeditor.net" />
*/

var FCKDomRange = function( sourceWindow )
{
	this.Window = sourceWindow ;
}

FCKDomRange.prototype.TypeName = 'FCKDomRange' ;		// @Packager.RemoveLine

FCKDomRange.prototype.CheckStartOfBlock = function()
{
	// Create a clone of the current range.
	var oTestRange = this.Clone() ;
	
	// Collapse it to its start point.
	oTestRange.Collapse( true ) ;
	
	// Move the start boundary to the start of the block.
	oTestRange.SetStart( oTestRange.StartBlock || oTestRange.StartBlockLimit, 1 ) ;
	
	var bIsStartOfBlock = oTestRange.CheckIsEmpty() ;

	oTestRange.Release() ;
	
	return bIsStartOfBlock ;
}

FCKDomRange.prototype.CheckEndOfBlock = function()
{
	var bIsEndOfBlock = false ;

	// Create a clone of the current range.
	var oTestRange = this.Clone() ;
	
	// Collapse it to its end point.
	oTestRange.Collapse( false ) ;
	
	// Move the end boundary to the end of the block.
	oTestRange.SetEnd( oTestRange.EndBlock || oTestRange.EndBlockLimit, 2 ) ;

	var bIsEndOfBlock = oTestRange.CheckIsEmpty() ;

	oTestRange.Release() ;
	
	return bIsEndOfBlock ;
}

FCKDomRange.prototype.Release = function( preserveWindow )
{
	if ( !preserveWindow )
		this.Window = null ;

	this.StartContainer = null ;
	this.StartBlock = null ;
	this.StartBlockLimit = null ;
	this.EndContainer = null ;
	this.EndBlock = null ;
	this.EndBlockLimit = null ;
	this._Range = null ;
}

FCKDomRange.prototype.MoveToElementStart = function( targetElement )
{
	this.SetStart(targetElement,1) ;
	this.SetEnd(targetElement,1) ;
}

FCKDomRange.prototype.CreateBookmark = function()
{
	var oBookmark = 
	{
		StartId	: 'fck_dom_range_start_' + (new Date()).valueOf() + '_' + Math.floor(Math.random()*1000),
		EndId	: 'fck_dom_range_end_' + (new Date()).valueOf() + '_' + Math.floor(Math.random()*1000)
	} ;

	var oDoc = this.Window.document ;
	
	var eSpan = oDoc.createElement( 'span' ) ;
	eSpan.id = oBookmark.EndId ;
	eSpan.innerHTML = '&nbsp;' ;	// For IE, it must have something inside, otherwise it may be removed during operations.

	var oClone = this.Clone() ;
	oClone.Collapse( false ) ;
	oClone.InsertNode( eSpan ) ;
	
	eSpan = oDoc.createElement( 'span' ) ;
	eSpan.id = oBookmark.StartId ;
	eSpan.innerHTML = '&nbsp;' ;	// For IE, it must have something inside, otherwise it may be removed during operations.

	var oClone = this.Clone() ;
	oClone.Collapse( true ) ;
	oClone.InsertNode( eSpan ) ;
	
	return oBookmark ;
}

FCKDomRange.prototype.MoveToBookmark = function( bookmark, preserveBookmark )
{
	var oDoc = this.Window.document ;
	var eStartSpan	=  oDoc.getElementById( bookmark.StartId ) ;
	var eEndSpan	=  oDoc.getElementById( bookmark.EndId ) ;

	this.SetStart( eStartSpan, 4 ) ;
	this.SetEnd( eEndSpan, 3 ) ;
	
	if ( !preserveBookmark )
	{
		FCKDomTools.RemoveNode( eStartSpan ) ;
		FCKDomTools.RemoveNode( eEndSpan ) ;
	}
}