﻿/* @Packager.Header
<FileDescription>
	Class for working with a selection range, much like the W3C DOM Range, but
	it is not intented to be an implementation of the W3C interface.
	(IE Implementation)
</FileDescription>
<Author name="Frederico Caldeira Knabben" email="www.fckeditor.net" />
*/

FCKDomRange.prototype.MoveToSelection = function()
{
	this.Release( true ) ;

	this._Range = new FCKW3CRange( this.Window.document ) ;

	var oSel = this.Window.document.selection ;
	
	if ( oSel.type != 'Control' )
	{
		// Set the start boundary.
		eMarker = this._GetSelectionMarkerTag( true ) ;
		this._Range.setStart( eMarker.parentNode, FCKDomTools.GetIndexOf( eMarker ) ) ;
		eMarker.parentNode.removeChild( eMarker ) ;

		// Set the end boundary.
		var eMarker = this._GetSelectionMarkerTag( false ) ;
		this._Range.setEnd( eMarker.parentNode, FCKDomTools.GetIndexOf( eMarker ) ) ;
		eMarker.parentNode.removeChild( eMarker ) ;
		
		this._UpdateElementInfo() ;
	}
}

FCKDomRange.prototype.Select = function()
{
	if ( this._Range )
	{
		// Create marker tags for the start and end boundaries.
		var eStartMarker	= this._GetRangeMarkerTag( true ) ;
		var eEndMarker		= this._GetRangeMarkerTag( false ) ;

		// Create the main range which will be used for the selection.
		var oIERange = this.Window.document.body.createTextRange() ;
		
		// Position the range at the start boundary.
		oIERange.moveToElementText( eStartMarker ) ;

		// Create a tool range for the end.
		var oIERangeEnd = this.Window.document.body.createTextRange() ;

		// Position the tool range at the end.
		oIERangeEnd.moveToElementText( eEndMarker ) ;
		
		// Move the end boundary of the main range to match the tool range.
		oIERange.setEndPoint( 'EndToEnd', oIERangeEnd ) ;
		
		// Select the range.
		oIERange.select() ;
		
		// Remove the markers (reset the position, because of the changes in the DOM tree).
		this._Range.setStartBefore( eStartMarker ) ;
		eStartMarker.parentNode.removeChild( eStartMarker ) ;
		this._Range.setEndBefore( eEndMarker ) ;
		eEndMarker.parentNode.removeChild( eEndMarker ) ;
	}
}

FCKDomRange.prototype._GetSelectionMarkerTag = function( toStart )
{
	// Get a range for the start boundary.
	var oRange = this.Window.document.selection.createRange() ;
	oRange.collapse( toStart === true ) ;
	
	// Paste a marker element at the collapsed range and get it from the DOM.
	var sMarkerId = 'fck_dom_range_temp_' + (new Date()).valueOf() + '_' + Math.floor(Math.random()*1000) ;
	oRange.pasteHTML( '<span id="' + sMarkerId + '"></span>' ) ;
	return this.Window.document.getElementById( sMarkerId ) ;
}

FCKDomRange.prototype._GetRangeMarkerTag = function( toStart )
{
	// Get a range for the start boundary.
	var oRange = this._Range ;
	
	// insertNode() will add the node at the beginning of the Range, updating
	// the endOffset if necessary. So, we can work with the current range in this case.
	if ( !toStart )
	{
		oRange = oRange.cloneRange() ;
		oRange.collapse( toStart === true ) ;
	}
	
	var eSpan = this.Window.document.createElement( 'span' ) ;
	oRange.insertNode( eSpan ) ;
	
	return eSpan ;
}