/*
Copyright (c) 2003-2010, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
 */

importPackage( org.mozilla.javascript );

importClass( java.lang.System );
importClass( java.io.File );
importClass( java.io.BufferedWriter );
importClass( java.io.FileWriter );

/*
 * Check if we're running the compiled version of this script. If yes, the
 * ckpackager class should be available.
 */
var isCompiled = true;
var command = "java -jar js.jar ckpackager.js";
var resource = JavaAdapter( org.mozilla.javascript.Parser )["class"].getResource( "/org/mozilla/javascript" ).toString();

try
{
	java.lang.Class.forName( "ckpackager.ckpackager" );
}
catch ( e )
{
	isCompiled = false;
}

if ( isCompiled )
{
	var quit = function()
	{
		System.exit( 0 );
	};

	loadClass( "ckpackager.includes.ckpackager" );

	if ( resource.indexOf( ".exe" ) != -1 )
		command = "ckpackager.exe";
	else
		command = "java -jar ckpackager.jar";
}
else
{
	var packagerPath = resource.replaceFirst( "^jar:", '' ).replaceFirst( "\/js\.jar\!\/org\/mozilla\/javascript$", '' )
			.replaceAll( "_dev.{1}_thirdparty.{1}rhino", "" );

	load( packagerPath + "_source/includes/ckpackager.js" );
	CKPACKAGER.path = packagerPath;
	CKPACKAGER.sourcePath = packagerPath + "_source/";
}

if ( !arguments[0] || arguments[0] == '-help' || arguments[0] == '/?')
	error( '\nUsage: ' + command + ' sample.pack [-v]' +
			'\n\n -v    Show the files being worked on as CKPackager is running.' +
			'\n       Display detailed exception information when an error occurs.');

CKPACKAGER.isCompiled = isCompiled;

function error( msg )
{
	print( msg );
	print( '' );
	quit();
}

if ( arguments.length > 1 && ( arguments[arguments.length - 1] == '-v' || arguments[arguments.length - 1] == '--verbose' ) )
	CKPACKAGER.verbose = 1;

if ( arguments[0] == '-dump' )
{
	CKPACKAGER.load( 'ckpackager.includes.parser' );
	CKPACKAGER.parser.dumpThree( CKPACKAGER.tools.readFile( arguments[1] ) );
	quit();
}
else if ( arguments[0] == '-compress' )
{
	CKPACKAGER.load( 'ckpackager.includes.scriptcompressor' );

	var compressed = CKPACKAGER.scriptCompressor.compress( CKPACKAGER.tools.readFile( arguments[1] ) );

	if ( arguments[2] )
	{
		var out = new BufferedWriter( new FileWriter( arguments[2] ) );
		out.write( compressed );
		out.close();
	}

	print( compressed );
	quit();
}
else if ( arguments[0] == '-test' && !isCompiled )
{
	load( packagerPath + "/test/test.js" );
	quit();
}

CKPACKAGER.packFile = arguments[0];
CKPACKAGER.packDir = ( function()
{
	var packFile = new File( CKPACKAGER.packFile );

	if ( !packFile.isFile() )
		error( 'The file name "' + CKPACKAGER.packFile + '" was not found.' );

	return packFile.getParent() || './';
} )();

CKPACKAGER.outputDir = CKPACKAGER.packDir;

CKPACKAGER.load( 'ckpackager.includes.packager' );

//for ( var o in CKPACKAGER )
//	print( o + ': ' + CKPACKAGER[o] );

// print( String( System.getProperties() ).replace( /,/g, '\n') );

( function()
{
	try
	{
		var packager = new CKPACKAGER.packager();
		packager.loadDefinitionFile( CKPACKAGER.packFile );
		packager.run();
	}
	catch ( e )
	{
		if ( CKPACKAGER.verbose )
		{
			if ( typeof ( e.rhinoException ) != 'undefined' )
			{
				e.rhinoException.printStackTrace();
				quit();
			}
			else if ( typeof ( e.javaException ) != 'undefined' )
			{
				e.javaException.printStackTrace();
				quit();
			}
		}

		print( "" );
		error( e );
	}
} )();
