﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * FCKContextMenu Class: renders an control a context menu.
 */

var FCKContextMenu = function( parentWindow, langDir )
{
	this.CtrlDisable = false ;

	var oPanel = this._Panel = new FCKPanel( parentWindow ) ;
	oPanel.AppendStyleSheet( FCKConfig.SkinPath + 'fck_editor.css' ) ;
	oPanel.IsContextMenu = true ;

	// The FCKTools.DisableSelection doesn't seems to work to avoid dragging of the icons in Mozilla
	// so we stop the start of the dragging
	if ( FCKBrowserInfo.IsGecko )
		oPanel.Document.addEventListener( 'draggesture', function(e) {e.preventDefault(); return false;}, true ) ;

	var oMenuBlock = this._MenuBlock = new FCKMenuBlock() ;
	oMenuBlock.Panel = oPanel ;
	oMenuBlock.OnClick = FCKTools.CreateEventListener( FCKContextMenu_MenuBlock_OnClick, this ) ;

	this._Redraw = true ;
}

FCKContextMenu.prototype.TypeName = 'FCKContextMenu' ;		// @Packager.RemoveLine

FCKContextMenu.prototype.SetMouseClickWindow = function( mouseClickWindow )
{
	if ( !FCKBrowserInfo.IsIE )
	{
		this._Document = mouseClickWindow.document ;

		// Opera doesn't provide a proper contextmenu event
		if ( FCKBrowserInfo.IsOpera )
			this.ConfigureOpera()

		this._Document.addEventListener( 'contextmenu', FCKContextMenu_Document_OnContextMenu, false ) ;
	}
}

FCKContextMenu.prototype.AddItem = function( name, label, iconPathOrStripInfoArrayOrIndex, isDisabled )
{
	var oItem = this._MenuBlock.AddItem( name, label, iconPathOrStripInfoArrayOrIndex, isDisabled) ;
	this._Redraw = true ;
	return oItem ;
}

FCKContextMenu.prototype.AddSeparator = function()
{
	this._MenuBlock.AddSeparator() ;
	this._Redraw = true ;
}

FCKContextMenu.prototype.RemoveAllItems = function()
{
	this._MenuBlock.RemoveAllItems() ;
	this._Redraw = true ;
}

FCKContextMenu.prototype.AttachToElement = function( element )
{
	if ( FCKBrowserInfo.IsIE )
		FCKTools.AddEventListenerEx( element, 'contextmenu', FCKContextMenu_AttachedElement_OnContextMenu, this ) ;
	else
		element._FCKContextMenu = this ;

//	element.onmouseup		= FCKContextMenu_AttachedElement_OnMouseUp ;
}

function FCKContextMenu_Document_OnContextMenu( e )
{
	// If we haven't created the event in Opera ignore it.
	if ( FCKBrowserInfo.IsOpera && !e.synthetic )
		return false;

	var el = e.target ;

	while ( el )
	{
		if ( el._FCKContextMenu )
		{
			if ( el._FCKContextMenu.CtrlDisable && ( e.ctrlKey || e.metaKey ) )
				return true ;

			FCKTools.CancelEvent( e ) ;
			FCKContextMenu_AttachedElement_OnContextMenu( e, el._FCKContextMenu, el ) ;
			return false ;
		}
		el = el.parentNode ;
	}
	return true ;
}

function FCKContextMenu_AttachedElement_OnContextMenu( ev, fckContextMenu, el )
{
//	var iButton = e ? e.which - 1 : event.button ;

//	if ( iButton != 2 )
//		return ;

	if ( fckContextMenu.CtrlDisable && ( ev.ctrlKey || ev.metaKey ) )
		return true ;

	var eTarget = el || this ;

	if ( fckContextMenu.OnBeforeOpen )
		fckContextMenu.OnBeforeOpen.call( fckContextMenu, eTarget ) ;

	if ( fckContextMenu._MenuBlock.Count() == 0 )
		return false ;

	if ( fckContextMenu._Redraw )
	{
		fckContextMenu._MenuBlock.Create( fckContextMenu._Panel.MainNode ) ;
		fckContextMenu._Redraw = false ;
	}
	
	// This will avoid that the content of the context menu can be dragged in IE
	// as the content of the panel is recreated we need to do it every time
	FCKTools.DisableSelection( fckContextMenu._Panel.Document.body ) ;

	fckContextMenu._Panel.Show(
		ev.pageX || ev.screenX,
		ev.pageY || ev.screenY,
		ev.currentTarget || null
	) ;

	return false ;
}

function FCKContextMenu_MenuBlock_OnClick( menuItem, contextMenu )
{
	contextMenu._Panel.Hide() ;
	FCKTools.RunFunction( contextMenu.OnItemClick, contextMenu, menuItem ) ;
}


///
// We will take care to firing our own contextmenu event in Opera
//
// TODO: The menu appears way too high.
//       Respect the preference to keep the default contextmenu on ctrl
// 		 Provide an alternative to show the contextmenu using left click + accelerator
// 		 review the code and test it!
FCKContextMenu.prototype.ConfigureOpera = function()
{
	doc = this._Document ;
	
	doc.addEventListener( 'mousedown', FCKContextMenu_Opera_mousedown, true ) ;

	doc.addEventListener( 'mouseup', FCKContextMenu_Opera_mouseup, true) ;
};

function FCKContextMenu_Opera_dispatchCtxMenuEvent( e, evType )
{
	var doc = e.target.ownerDocument || (e.view ? e.view.document : null) || e.target ;
	var newEv = doc.createEvent( 'MouseEvent' ) ;
	newEv.initMouseEvent( evType||'contextmenu', true, true, doc.defaultView, e.detail,
		e.screenX, e.screenY, e.clientX, e.clientY, e.ctrlKey, e.altKey,
		e.shiftKey, e.metaKey, e.button, e.relatedTarget ) ;
	newEv.synthetic = true ;
	e.target.dispatchEvent( newEv ) ;
}

function FCKContextMenu_Opera_mousedown(e)
{
	//right-click doesn't fire click event. Only mouseup
	if ( e && e.button == 2 )
	{
		FCKContextMenu_Opera_cancelMenu( e ) ;
		return false ;
	}
}

var overrideButton ;
	
function FCKContextMenu_Opera_cancelMenu( e )
{
	if( !overrideButton )
	{
		var doc = e.target.ownerDocument ;
		overrideButton = doc.createElement( 'input' ) ;
		overrideButton.type = 'button' ;
		(doc.body||doc.documentElement).appendChild( overrideButton ) ;
	}
	overrideButton.style = 'position:absolute;top:'+(e.clientY-2)+'px;left:'+(e.clientX-2)+'px;width:5px;height:5px;opacity:0.01' ;
}

function FCKContextMenu_Opera_mouseup( e )
{
	if ( overrideButton )
	{
		overrideButton.parentNode.removeChild( overrideButton ) ;
		overrideButton = undefined ;
	}
	if( e && e.button == 2 )
	{
		//contextmenu must be fired here if we want to cancel the menu
		FCKContextMenu_Opera_dispatchCtxMenuEvent( e, 'contextmenu' ) ;
		return false ;
	}
}