﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * FCKShowBlockCommand Class: the "Show Blocks" command.
 */

var FCKShowBlockCommand = function( name )
{
	this.Name = name ;
	this.CSSText = this._GetCSSText( ['p', 'div', 'pre', 'address', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'] ) ;
	this.StyleSheetObj = null ;
}
FCKShowBlockCommand.prototype.Execute = function()
{
	if ( this._IsVisible() )
		this._SetInvisible() ;
	else
		this._SetVisible() ;
	FCK.Events.FireEvent( 'OnSelectionChange' ) ;
}
FCKShowBlockCommand.prototype.GetState = function()
{
	if ( FCK.EditMode != FCK_EDITMODE_WYSIWYG )
		return FCK_TRISTATE_DISABLED ;
	return this._IsVisible() ? FCK_TRISTATE_ON : FCK_TRISTATE_OFF ;
}
FCKShowBlockCommand.prototype._IsVisible = function()
{
	// The try.. catch... statements are here because accessing a stylesheet object of an inactive 
	// document would raise access denied error in IE.
	// In such a case, we should clear the reference to prevent further errors, before returning false.
	try
	{
		if ( ! this.StyleSheetObj )
			return false ;
	}
	catch ( e )
	{
		this.StyleSheetObj = null ;
		return false ;
	}
	if ( FCKBrowserInfo.IsIE )
	{
		try
		{
			if ( this.StyleSheetObj.cssText == '' 
					|| ! this.StyleSheetObj.owningElement 
					|| this.StyleSheetObj.owningElement.ownerDocument != FCK.EditorDocument )
				return false ;
			else
				return true ;
		}
		catch ( e )
		{
			this.StyleSheetObj = null ;
			return false ;
		}
	}
	else
	{
		if ( this.StyleSheetObj.parentNode && this.StyleSheetObj.ownerDocument == FCK.EditorDocument )
			return true ;
		else
			return false ;
	}
}
FCKShowBlockCommand.prototype._SetVisible = function()
{
	if ( FCK.EditMode != FCK_EDITMODE_WYSIWYG )
		return ;
	if ( ! this.StyleSheetObj )
	{
		this.StyleSheetObj = FCKTools._AppendStyleString( FCK.EditorDocument, this.CSSText ) ;
		return ;
	}

	if ( FCKBrowserInfo.IsIE )
		this.StyleSheetObj.cssText = this.CSSText ;
	else
		FCK.EditorDocument.getElementsByTagName( 'head' )[0].appendChild( this.StyleSheetObj ) ;
}
FCKShowBlockCommand.prototype._SetInvisible = function()
{
	if ( FCK.EditMode != FCK_EDITMODE_WYSIWYG )
		return ;
	if ( ! this.StyleSheetObj )
		return ;

	if ( FCKBrowserInfo.IsIE )
		this.StyleSheetObj.cssText = '' ;
	else
	{
		if ( this.StyleSheetObj.parentNode )
			this.StyleSheetObj.parentNode.removeChild( this.StyleSheetObj ) ;
	}
}
FCKShowBlockCommand.prototype._GetCSSText = function( tags )
{
	var template = '$TAG'
			+ '{'
			+ 'background-image: url($BASEPATHimages/block_$TAG.png);' 
			+ 'background-repeat: no-repeat;' 
			+ 'border: 1px dotted gray;'
			+ 'padding-top: 8px;'
			+ 'padding-left: 8px;'
			+ '}\n';

	var retval = '' ;
	for ( var i = 0 ; i < tags.length ; i++ )
		retval += template.replace( new RegExp( '\\$TAG', 'g' ), tags[i] ) ;
	retval = retval.replace( new RegExp( '\\$BASEPATH', 'g' ), FCKConfig.BasePath ) ;
	return retval ;
}
