/**
 * @tc
 * @name Test open dialog on pasted table (#7900).
 * @tags table,copy,paste
 * @browsers ff
 */

// Load the page, switch the demo page language to 'en'.
browser.get( vars[ 'base' ] + "ui_languages.html" );
sampleLanguageTo( 'en' );

var editor = browser.editor( 'editor1' );

// Copy one table cell and paste into fresh document.
editor.data( '<table><tr><td>cell</td></tr></table>' );
wait( 500 );
editor.selection( "//tr`0,//tr`1" ).type( Keys.CONTROL, 'c' );
editor.button( 'New Page').type( Keys.CONTROL, 'v' );

// Open Table Properties Dialog.
editor.selection( "//td`0,//td`1" ).contextmenu();
editor.panel().item( 'Table Properties' );
wait( 500 );

// Check table dialog row/column field values.
var cols = editor.runAtEditor( function( editor ) { return CKEDITOR.dialog._.currentTop.getContentElement( 'info','txtCols' ).getValue(); }),
	rows = editor.runAtEditor( function( editor ) { return CKEDITOR.dialog._.currentTop.getContentElement( 'info','txtRows' ).getValue(); });

Assert.areEqual(1, cols, "Table columns field doesn't match." );
Assert.areEqual(1, rows, "Table rows field doesn't match." );
