/*
Copyright (c) 2003-2012, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
 */

importClass( java.io.StringWriter );
importClass( java.io.FileInputStream );

importClass( javax.xml.parsers.DocumentBuilderFactory );
importClass( javax.xml.transform.dom.DOMSource );
importClass( javax.xml.transform.OutputKeys );
importClass( javax.xml.transform.stream.StreamResult );
importClass( javax.xml.transform.TransformerFactory );

importClass( org.w3c.dom.Document );
importClass( org.xml.sax.EntityResolver );
importClass( org.xml.sax.InputSource );
importClass( org.xml.sax.SAXException );

( function()
{
	var DTDResolver =
	{
		VARIANT_DTD : "/variant.dtd",
		XHTML_1_0_TRANSITIONAL_DTD : "/dtd/xhtml1-transitional.dtd",
		XHTML_1_0_LATIN_1_ENT : "/dtd/xhtml-lat1.ent",
		XHTML_1_0_SYMBOL_ENT : "/dtd/xhtml-symbol.ent",
		XHTML_1_0_SPECIAL_ENT : "/dtd/xhtml-special.ent",

		resolveEntity : function( publicId, systemId )
		{
			var dtd;

			if ( !CKRELEASER.isCompiled )
			{
				if ( systemId.equals( "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" ) )
					dtd = new FileInputStream( new File( CKRELEASER.path + "_dev/_thirdparty/", this.XHTML_1_0_TRANSITIONAL_DTD ) );
				else if ( systemId.endsWith( "xhtml-lat1.ent" ) )
					dtd = new File( CKRELEASER.path + "_dev/_thirdparty/", this.XHTML_1_0_LATIN_1_ENT );
				else if ( systemId.endsWith( "xhtml-symbol.ent" ) )
					dtd = new File( CKRELEASER.path + "_dev/_thirdparty/", this.XHTML_1_0_SYMBOL_ENT );
				else if ( systemId.endsWith( "xhtml-special.ent" ) )
					dtd = new File( CKRELEASER.path + "_dev/_thirdparty/", this.XHTML_1_0_SPECIAL_ENT );
				else
					return null;
			}
			else
			{
				if ( systemId.equals( "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" ) )
					dtd = this.getClass().getResourceAsStream( this.XHTML_1_0_TRANSITIONAL_DTD );
				else if ( systemId.endsWith( "xhtml-lat1.ent" ) )
					dtd = this.getClass().getResourceAsStream( this.XHTML_1_0_LATIN_1_ENT );
				else if ( systemId.endsWith( "xhtml-symbol.ent" ) )
					dtd = this.getClass().getResourceAsStream( this.XHTML_1_0_SYMBOL_ENT );
				else if ( systemId.endsWith( "xhtml-special.ent" ) )
					dtd = this.getClass().getResourceAsStream( this.XHTML_1_0_SPECIAL_ENT );
				else
					return null;
			}

			return new InputSource( dtd );
		}
	};

	var ddtdr = new org.xml.sax.EntityResolver( DTDResolver );
	var docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
	docBuilder.setEntityResolver( ddtdr );

	CKRELEASER.xml =
	{

		replaceNodeWithNodes : function( document, oldNode, nodeList )
		{
			var length = nodeList.getLength();
			for ( var i = 0 ; i < length ; i++ )
			{
				/**
				 * Skip empty text nodes (containing white space characters) at the beginning and at the end.
				 */
				if ( ( i === 0 || i == length - 1 ) && nodeList.item( i ).getNodeType() == org.w3c.dom.Node.TEXT_NODE
						&& nodeList.item( i ).getNodeValue().match( /^\s*$/ ) !== null )
					continue;

				oldNode.getParentNode().insertBefore( document.importNode( nodeList.item( i ), true ), oldNode );
			}

			oldNode.getParentNode().removeChild( oldNode );
		},

		replaceNode : function( document, oldNode, newNode )
		{
			oldNode.getParentNode().insertBefore( document.importNode( newNode, true ), oldNode );
			oldNode.getParentNode().removeChild( oldNode );
		},

		loadDocument : function( location )
		{
			return docBuilder.parse( location );
		},

		asXml : function( document, node )
		{
			var transformer = TransformerFactory.newInstance().newTransformer();
			transformer.setOutputProperty( OutputKeys.INDENT, "no" );
			transformer.setOutputProperty( OutputKeys.OMIT_XML_DECLARATION, "yes" );

			var result = new StreamResult( new StringWriter() );
			var source = new DOMSource( document );
			if ( node )
				source.setNode( node );
			transformer.transform( source, result );

			return result.getWriter().toString();
		},

		/**
		 * FIXME: New line characters in comments are changed. x0Dx0A is changed
		 * into x0A.
		 */
		saveXml : function( document, file )
		{
			var docType = document.getDoctype();
			var transformer = TransformerFactory.newInstance().newTransformer();
			transformer.setOutputProperty( OutputKeys.DOCTYPE_PUBLIC, docType.getPublicId() );
			transformer.setOutputProperty( OutputKeys.DOCTYPE_SYSTEM, docType.getSystemId() );
			transformer.setOutputProperty( OutputKeys.INDENT, "no" );
			transformer.setOutputProperty( OutputKeys.OMIT_XML_DECLARATION, "yes" );

			var result = new StreamResult( file );
			var source = new DOMSource( document );
			transformer.transform( source, result );
		}
	};
} )();
