﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * FCKJustifyCommand Class: controls text justification.
 */

var FCKJustifyCommand = function( alignValue )
{
	this.AlignVaue = alignValue ;
	this.CurrentState = FCK_TRISTATE_DISABLED ;
}

FCKJustifyCommand.prototype = 
{
	Execute : function()
	{
		var range = new FCKDomRange( FCK.EditorWindow ) ;
		range.MoveToSelection() ;
		var bookmark = range.CreateBookmark() ;
		range.Expand( 'block_contents' ) ;
		if ( range.StartContainer == range.Window.document.body )
			range.FixBlock( true ) ;
		range.StartContainer.removeAttribute( 'align' ) ;

		if ( this.CurrentState == FCK_TRISTATE_OFF)
			range.StartContainer.style.textAlign = this.AlignVaue ;
		else if ( this.CurrentState == FCK_TRISTATE_ON )
			range.StartContainer.style.textAlign = '' ;

		range.MoveToBookmark( bookmark ) ;
		range.Select() ;
		FCK.Events.FireEvent( 'OnSelectionChange' ) ;
	},

	GetState : function()
	{
		if ( FCK.EditMode != FCK_EDITMODE_WYSIWYG || ! FCK.EditorWindow )
		{
			this.CurrentState = FCK_TRISTATE_DISABLED ;
			return this.CurrentState ;
		}

		var parentEl = FCKSelection.GetParentElement() ;
		var nearestBlock = parentEl ;
		while ( nearestBlock )
		{
			if ( FCKListsLib.BlockBoundaries[nearestBlock.nodeName.toLowerCase()] )
				break ;
			nearestBlock = nearestBlock.parentNode ;
		}

		if ( ! nearestBlock )
		{
			this.CurrentState = FCK_TRISTATE_OFF ;
			return this.CurrentState ;
		}

		if ( nearestBlock.align == this.AlignVaue || nearestBlock.style.textAlign == this.AlignVaue  )
		{
			this.CurrentState = FCK_TRISTATE_ON ;
			return this.CurrentState ;
		}
		else
		{
			this.CurrentState = FCK_TRISTATE_OFF ;
			return this.CurrentState ;
		}
	}
} ;
