﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * FCKJustifyCommand Class: controls block justification.
 */

var FCKJustifyCommand = function( alignValue )
{
	this.AlignValue = alignValue ;
	this.CurrentState = FCK_TRISTATE_DISABLED ;
	this.DefaultAlign = ( alignValue == 'left' && FCKConfig.ContentLangDirection.IEquals( 'ltr' ) ) ||
			( alignValue == 'right' && FCKConfig.ContentLangDirection.IEquals( 'rtl' ) ) ;
}

FCKJustifyCommand.prototype = 
{
	Execute : function()
	{
		var range = new FCKDomRange( FCK.EditorWindow ) ;
		range.MoveToSelection() ;

		// Store a bookmark of the selection since the paragraph iterator might change the DOM tree and break selections.
		var bookmark = range.CreateBookmark() ;
		var iterator = new FCKDomRangeIterator( range ) ;
		var block = null ;
		var cssClassName = this._GetCSSClassName() ;

		// Apply alignment setting for each paragraph.
		while ( ( block = iterator.GetNextParagraph() ) )
		{
			block.removeAttribute( 'align' ) ;

			if ( cssClassName )
			{
				block.className = block.className.replace( FCKConfig.JustifyClassPattern, ' ' ) ;
				if ( block.className.length && block.className.charAt( block.className.length - 1 ) != ' ' )
					block.className += ' ' + cssClassName ;
				else
					block.className += cssClassName ;
			}
			else
			{
				if ( this.CurrentState == FCK_TRISTATE_OFF)
					block.style.textAlign = this.AlignValue ;
				else if ( this.CurrentState == FCK_TRISTATE_ON )
					block.style.textAlign = '' ;
			}
		}

		// Restore previous selection.
		range.MoveToBookmark( bookmark ) ;
		range.Select() ;
		FCK.Events.FireEvent( 'OnSelectionChange' ) ;
	},

	GetState : function()
	{
		if ( FCK.EditMode != FCK_EDITMODE_WYSIWYG || ! FCK.EditorWindow )
		{
			this.CurrentState = FCK_TRISTATE_DISABLED ;
			return this.CurrentState ;
		}

		// Retrieve the first selected block.
		var firstBlock = null ;
		if ( FCKBrowserInfo.IsIE )
		{
			var range = FCK.EditorDocument.selection.createRange() ;
			range.collapse( true ) ;
			firstBlock = ( new FCKElementPath( range.parentElement() ) ).Block ;
		}
		else
		{
			var sel = FCK.EditorWindow.getSelection() ;
			if ( ! sel || sel.rangeCount < 0 )
			{
				this.CurrentState = FCK_TRISTATE_DISABLED ;
				return this.CurrentState ;
			}
			var range = sel.getRangeAt( 0 ) ;
			firstBlock = ( new FCKElementPath( range.startContainer ) ).Block ;
		}

		if ( ! firstBlock || firstBlock.nodeName.IEquals( 'body' ) )
		{
			this.CurrentState = FCK_TRISTATE_OFF ;
			return this.CurrentState ;
		}

		// See if the desired style is already applied to the first block.
		var cssClassName = this._GetCSSClassName() ;
		if ( ! cssClassName )
		{
			if ( ! firstBlock.align && ! firstBlock.style.textAlign && this.DefaultAlign )
				return FCK_TRISTATE_ON ;
			this.CurrentState = ( firstBlock.align == this.AlignValue || firstBlock.style.textAlign == this.AlignValue ?
					FCK_TRISTATE_ON : FCK_TRISTATE_OFF ) ;
		}
		else
		{
			if ( firstBlock.className.search( FCKConfig.JustifyClassPattern ) == -1 && this.DefaultAlign )
				return FCK_TRISTATE_ON ;
			this.CurrentState = ( firstBlock.className.search( new RegExp( '(^|\\s+)' + cssClassName + '($|\\s+)' ) ) == -1 ? 
						FCK_TRISTATE_OFF : FCK_TRISTATE_ON ) ;
		}

		return this.CurrentState ;
	},

	_GetCSSClassName : function()
	{
		var cssClassName = null ;
		switch ( this.AlignValue )
		{
			case 'left' :
				cssClassName = FCKConfig.LeftJustifyClass ;
				break ;
			case 'right' :
				cssClassName = FCKConfig.RightJustifyClass ;
				break ;
			case 'center' :
				cssClassName = FCKConfig.CenterJustifyClass ;
				break ;
			case 'justify' :
				cssClassName = FCKConfig.FullJustifyClass ;
				break ;
		}
		return cssClassName ;
	}
} ;
