/*
* @example An iframe-based dialog with custom button handling logics.
*/
( function() {
    CKEDITOR.plugins.add( 'iframe-fit-size-n',
    {
        requires: 'iframedialog',
		
		icons : 'myiframedialog2',
		
        init: function( editor )
        {
           var iframewindow = null;
		   var me = this;
           CKEDITOR.dialog.add( 'myiframedialog2', function ()
           {
              return {
                 title : 'My Iframe Dialog 2',
                 width : 750,
                 height : 650,
				 buttons : [CKEDITOR.dialog.okButton, CKEDITOR.dialog.cancelButton ],
                 contents :
                       [
                          {
                             id : 'iframe',
                             label : 'some label...',
                             expand : true,
                             elements :
                                   [
                                      {
                                         type : 'iframe',
                                         src : 'http://192.168.1.1/ckeditor4/samples/replacebyclass.html',
                                         width : '100%',
                                         height : '100%',
										 //style : 'width:100%;height:100%;',
                                         onContentLoad : function() {
                                            // Iframe is loaded...											
											var iframe = document.getElementById( this._.frameId );
											iframeWindow = iframe.contentWindow; 
                                         }
                                      }
                                   ]
                          }
                       ],
                 onOk : function()
                 {
					console.log('ok called');
                 },
				 onShow : function()
                 {
					
				 }
              };
           } );

            editor.addCommand( 'myiframedialog2', new CKEDITOR.dialogCommand( 'myiframedialog2' ) );

            editor.ui.addButton( 'Myiframedialog2',
            {
                label: 'Some label',
                command: 'myiframedialog2',               
				toolbar: 'document,50'
				
            } );			
        }		
    } );
} )();