﻿/*
 * Dropdown menu options for FCKEditor.
 * (c) 2007 Martin Knowles
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * This plugin enhances the core toolbar with the ability to have one action
 * on the button face and one on the down arrow.
 *
 * This plugin provides three toolbar buttons, which can be used as straight
 * replacements for the current buttons:
 *   - DropOL
 *   - DropUL
 *   - DropFontSize
 *
 * The icon that's part of this plugin needs to be moved into your themes
 * directory if you are using DropFontSize.
 *   
 * This code needs I18N work.
 * 
 */


//Return the nearest ancestor to the current position of the caret.
FCKSelection.GetCaretAncestor = function(strTag)
{
	var e = FCKSelection.GetParentElement();
	var tn = e ?	FCKTools.GetElementAscensor(e,strTag) :
					FCKSelection.MoveToAncestorNode(strTag);
	return tn;
}

///////////////////////////////////////////////////////////////////////

// Text color

// FIXME: At present, the default color is 'automatic', but this could be
// ultimately set as a default in fckconfig.

FCKTextColorCommand.prototype.Execute = function( panelX, panelY, relElement, dropdown )
{
	// We must "cache" the actual panel type to be used in the SetColor method.
	FCK._ActiveColorPanelType = this.Type ;
	if (dropdown)
	{
		// Show the Color Panel at the desired position.
		this._Panel.Show( panelX, panelY, relElement ) ;
	}
	else
	{	
		this.SetColor( this._Color ? this._Color : '' ) ;
	}
}

FCKTextColorCommand.prototype.SetColorEx = FCKTextColorCommand.prototype.SetColor;
FCKTextColorCommand.prototype.SetColor = function( color )
{
	this.SetColorEx(color);
	// keep the last selected color around
	this._Color = color;
}


// UL selector
var FCKDropULCommand = function()
{
	var oWindow = FCKBrowserInfo.IsIE ? window : window.parent ;
	this._combo = new FCKSpecialCombo("Bulleted List",100,150,null,oWindow);
	this._Panel = this._combo._Panel;

	this._combo.AddItem( 'disc', '<ul><li type="disc">Disc</li><ul>', 'Disc' ) ;
	this._combo.AddItem( 'circle', '<ul><li type="circle">Circle</li><ul>', 'Circle' ) ;
	this._combo.AddItem( 'square', '<ul><li type="square">Square</li><ul>', 'Square' ) ;
	this._combo.OnSelect = this.OnSelect;
	// Future addition: walk the stylesheet and add extra li styles here
	
}

FCKDropULCommand.prototype.Execute = function( panelX, panelY, relElement, dropdown )
{
	if (dropdown)
		this._Panel.Show( panelX, panelY, relElement ) ;
	else
	{
		//already selected? cancel it
		if (FCK.GetNamedCommandState( 'InsertUnorderedList' ) == FCK_TRISTATE_ON)
		{
			FCKCommands.GetCommand('InsertUnorderedList').Execute();
			return;
		}
		//create the UL and use the default type
		FCKCommands.GetCommand('InsertUnorderedList').Execute();
		var ul = FCK.Selection.GetCaretAncestor('UL');
		if (ul) ul.type = 'disc';
	}
}

FCKDropULCommand.prototype.OnSelect = function(id, elem)
{
	//create the UL if we don't have one
	if (FCK.GetNamedCommandState( 'InsertUnorderedList' ) == FCK_TRISTATE_OFF)
		FCKCommands.GetCommand('InsertUnorderedList').Execute();
	var ul = FCK.Selection.GetCaretAncestor('UL');
	if (ul) ul.type = id;
	FCK.Focus() ;
}

FCKDropULCommand.prototype.GetState = function()
{
	return FCK.GetNamedCommandState( 'InsertUnorderedList' ) ;
}
FCKCommands.RegisterCommand( 'DropULCommand' , new FCKDropULCommand() ) ; 

FCKToolbarItems.RegisterItem( 'DropUL', new FCKToolbarPanelButton('DropULCommand', 'Bulleted List','Bulleted List', null, 27, true)) ;

// OL selector
var FCKDropOLCommand = function()
{
	var oWindow = FCKBrowserInfo.IsIE ? window : window.parent ;
	this._combo = new FCKSpecialCombo("Numbered List",100,150,null,oWindow);
	this._Panel = this._combo._Panel;
	
	this._combo.AddItem( '1', '<ol><li type="1">2,3,4...</li></ol>', '1' ) ;
	this._combo.AddItem( 'A', '<ol><li type="A">B.C.D...</li></ol>', 'A' ) ;
	this._combo.AddItem( 'a', '<ol><li type="a">b,c,d...</li></ol>', 'a' ) ;
	this._combo.AddItem( 'I', '<ol><li type="I">II,III,IV,...</li></ol>', 'I' ) ;
	this._combo.AddItem( 'i', '<ol><li type="i">ii,iii,iv,...</li></ol>', 'i' ) ;
	this._combo.OnSelect = this.OnSelect;
}

FCKDropOLCommand.prototype.Execute = function( panelX, panelY, relElement, dropdown )
{
	if (dropdown)
		this._Panel.Show( panelX, panelY, relElement ) ;
	else
	{
		//already selected? cancel it
		if (FCK.GetNamedCommandState( 'InsertOrderedList' ) == FCK_TRISTATE_ON)
		{
			FCKCommands.GetCommand('InsertOrderedList').Execute();
			return;
		}
		FCKCommands.GetCommand('InsertOrderedList').Execute();
		var ol = FCK.Selection.GetCaretAncestor('OL');
		if (ol) ol.type = '1';	
	}
}

FCKDropOLCommand.prototype.OnSelect = function(id, elem)
{
	//create the UL if we don't have one
	if (FCK.GetNamedCommandState( 'InsertOrderedList' ) == FCK_TRISTATE_OFF)
		FCKCommands.GetCommand('InsertOrderedList').Execute();
	var ol = FCK.Selection.GetCaretAncestor('OL');
	if (ol) ol.type = id;
	FCK.Focus() ;
}

FCKDropOLCommand.prototype.GetState = function()
{
	return FCK.GetNamedCommandState( 'insertorderedlist' );
}

FCKCommands.RegisterCommand( 'DropOLCommand' , new FCKDropOLCommand() ) ; 

FCKToolbarItems.RegisterItem( 'DropOL'	, new FCKToolbarPanelButton('DropOLCommand', 'Numbered List','Numbered List', null, 26, true)) ;

// Font size selector

var FCKDropFontSizeCommand = function()
{
	this.Name = "DropFontSize";
	var oWindow = FCKBrowserInfo.IsIE ? window : window.parent ;
	this._combo = new FCKSpecialCombo("FontSize",100,170,null,oWindow);
	this._Panel = this._combo._Panel;

	this._combo.OnSelect = this.OnSelect;
}

FCKDropFontSizeCommand.prototype.GetState = function()
{
	return FCK.GetNamedCommandState( 'FontSize' ) ;
}


FCKDropFontSizeCommand.prototype.Execute = function( panelX, panelY, relElement )
{
	if (this._Panel.CheckIsOpened())
	{
		this._Panel.Hide();
		return;
	}
	this._combo.DeselectAll() ;
	this._combo.ClearItems();
	var oTargetDoc = this._combo._Panel.Document ;
	var aCSSs = FCKConfig.EditorAreaCSS ;
	for ( var i = 0 ; i < aCSSs.length ; i++ ){
		FCKTools.AppendStyleSheet( oTargetDoc, aCSSs[i] ) ;
	}
	var oElem = FCK.Selection.GetParentElement();
	var strStyle;
	while (!strStyle && oElem)
	{
		strStyle = oElem.className;
		if (strStyle.search(/FCK_/) > -1) strStyle = null;
		oElem = oElem.parentElement;
	}
	if (!oElem) oElem = FCK.Selection.GetParentElement();
	var strTag = (oElem && oElem.tagName != 'BODY') ? oElem.tagName : 'span';

	var aSizes = FCKConfig.FontSizes.split(';') ;
	this._combo.AddItem('', '<' + strTag + ' class="' + strStyle + '">(none)</'+strTag+'>', '') ;
	for ( var i = 0 ; i < aSizes.length ; i++ )
	{
		var aSizeParts = aSizes[i].split('/') ;
		this._combo.AddItem( aSizeParts[0], '<' + strTag + ' class="' + strStyle + '"><font size="' + aSizeParts[0] + '">' + aSizeParts[1] + '</font></'+strTag+'>', aSizeParts[1] ) ;
	}

	this._Panel.Show( panelX, panelY, relElement ) ;
}

FCKDropFontSizeCommand.prototype.OnSelect = function(id, elem)
{
	FCKCommands.GetCommand('FontSize').Execute(id);
	FCK.Focus() ;
}



FCKCommands.RegisterCommand( 'DropFontSize' , new FCKDropFontSizeCommand() ) ; 

FCKToolbarItems.RegisterItem( 'DropFontSize'	, new FCKToolbarPanelButton('DropFontSize', 'Font Size','Font Size', null, null));
