﻿CKEDITOR.plugins.add('infolandHyperlink',
{
    "init": function (editor)
    {
        //remove the "Edit link" option from the context menu
        delete editor._.menuItems.link

        var strCKEditorControlName = editor.name.substring(0, editor.name.length - 41);

        // Register the command.
        var command = editor.addCommand('infolandHyperlink', CKEDITOR.plugins.infolandHyperlink);

        // Register the toolbar button.
        editor.ui.addButton('infolandHyperlink',
			{
			    label: window[strCKEditorControlName].languageLookup["INFOLANDHYPERLINK"],
			    command: 'infolandHyperlink',
			    icon: this.path + '../../Infoland/Icons/16x16_Hyperlink.png'
			});

        // Register the toolbar button.
        editor.ui.addButton('infolandHyperlinkInfo',
			{
			    label: 'infolandhyperlinkinfolabel',
			    command: 'infolandHyperlinkInfo',
			    icon: this.path + '../../Infoland/Icons/16x16_Hyperlink.png'
			});

        editor.addCommand("infolandUnlink", {
            exec: function (editor)
            {
                var objSelection = editor.getSelection();
                var objStyle = new CKEDITOR.style({ element: "a", type: CKEDITOR.STYLE_INLINE, alwaysRemoveElement: 1 });
                editor.removeStyle(objStyle);
            }
        });

        var objUnlinkCommand = {
            label: editor.lang.image.menu,
            command: 'infolandUnlink',
            group: 'link'
        };

        editor.contextMenu.addListener(function (element, selection)
        {
            if (element.getName() == 'a')
            {
                return {
                    infolandUnlink: CKEDITOR.TRISTATE_OFF
                };
            }
        });

        editor.addMenuItems({
            "infolandUnlink": {
                label: editor.lang.link.unlink,
                command: 'infolandUnlink',
                group: 'link',
                icon: this.path + '../../Infoland/Icons/Unlink.png',
                order: 1
            }
        });

        // Register selection change handler for the unlink button.
        /*editor.on('selectionChange', function (evt)
        {
            if (editor.readOnly)
                return;

            /*
             * Despite our initial hope, document.queryCommandEnabled() does not work
             * for this in Firefox. So we must detect the state by element paths.
             */

            /*DISABLED BECAUSE THIS DOESNT WORK PROPERLY

            var command = editor.getCommand('infolandHyperlink');
            if (evt.data.selection.getSelectedText() == '')
                command.setState(CKEDITOR.TRISTATE_DISABLED);
            else
                command.setState(CKEDITOR.TRISTATE_OFF);
        });*/
    }
});

CKEDITOR.plugins.infolandHyperlink = 
{
    "exec": function (editor)
    {
        if (editor.getSelection().getSelectedText() != '')
        {
            var strName = editor.name.substring(0, editor.name.length - 41);

            var blnContinue = true;
            var objNativeSelection = editor.getSelection().getNative()
            if (objNativeSelection != null)
            {
                var strHTML;
                if (objNativeSelection.getRangeAt)
                {
                    objContents = objNativeSelection.getRangeAt(0).cloneContents();
                    var objDiv = document.createElement('div');
                    objDiv.appendChild(objContents);
                    strHTML = objDiv.innerHTML;
                }
                else
                {
                    objContents = objNativeSelection.createRange().duplicate();
                    strHTML = objContents.htmlText;
                    strHTML = strHTML.replace(/[\r\n]/g, '');
                }

                if (strHTML.match(/<p>.*?<p>/gi) != null)
                {
                    blnContinue = false;
                    alert(window[strName].languageLookup["INFOLANDHYPERLINK_NOTALLOWEDMULTILINE"]);
                }
            }
            
            if(blnContinue)
            {
                var objEditor = editor;
                window[strName + '_OnHyperlinkSelected'] = function (objResults)
                {
                    var objResult = objResults[0];
                    objEditor.focus();

                    var html = '<a href="HyperlinkLoader.aspx?HyperlinkID=' + objResult.TemporaryID + '">' + objEditor.getSelection().getSelectedText() + '</a>';
                    var newElement = CKEDITOR.dom.element.createFromHtml(html, CKEDITOR.plugins.infolandHyperlink._document);
                    objEditor.insertElement(newElement);
                }

                window[strName + '_InsertHyperlink']();
            }
        }
    },
    canUndo: false,
    readOnly: 1
};

CKEDITOR.plugins.infolandHyperlinkInfo =
{
    "exec": function (editor)
    {
        alert('Geef info over de hyperlink');
    },
    canUndo: false,
    readOnly: 1
};
