CKEDITOR.on( 'instanceReady', function( event )
{
    // Ends self closing tags the HTML4 way, like <br>.
    event.editor.dataProcessor.writer.selfClosingEnd = '>';
    // Output paragraphs as <p>Text</p>.
    event.editor.dataProcessor.writer.setRules( 'p', {
        indent : false, breakBeforeOpen : false, breakAfterOpen : false, breakBeforeClose : false, breakAfterClose : false
    });
    //osetreni pre aby se nevkladal enter za <pre> kvuli geshi pluginu
    event.editor.dataProcessor.writer.setRules( 'pre', {
        indent : false, breakBeforeOpen : false, breakAfterOpen : false, breakBeforeClose : false, breakAfterClose : false
    });
    CKEDITOR.dtd.$removeEmpty['span'] = 0; // for glyphicons //CKEDITOR.dtd.$removeEmpty.span = 0;//
    CKEDITOR.dtd.$removeEmpty['i'] = 0;  // if you want to use font-awesome icons
});

CKEDITOR.editorConfig = function( config )
{

    // Enable all default text formats:
    config.format_tags = 'p;h1;h2;h3;h4;h5;h6;pre;address;div';

    config.toolbarStartupExpanded = false;
    config.toolbarCanCollapse = true;//must be true due possible to hide >=2.row

    config.docType = '<!DOCTYPE html>'; //'<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">';
    config.emailProtection = 'encode';


    // In CKEditor 4.1 or higher you need to disable ACF for some plugins
    config.allowedContent = true; //pokud true, tak nefunguji nasledujici filtry a odstranuje jiny obsah
    config.extraAllowedContent = {
        'script div': true,
        'div span p a em strong ': { attributes: ['itemscope','itemtype','itemprop'] }, //for microdata
        'time':{ attributes: ['itemprop','datetime'] }, //for microdata
    };
    config.disallowedContent = 'table[cellspacing,cellpadding,border]'; // kvuli html5

    // Paragraphs are now made by pressing shift and enter together instead
    config.enterMode = CKEDITOR.ENTER_P;
    // Enter key means br not p
    config.shiftEnterMode = CKEDITOR.ENTER_BR;

    config.fillEmptyBlocks = false; //false->nefunguje v CK 4.4.6 cursor focus
    config.ignoreEmptyParagraph=false;
    config.tabSpaces = 4;
    config.autoParagraph = false;

    //vlozeny text prevede na neformatovany text
    config.forcePasteAsPlainText = true;
    config.AutoDetectPasteFromWord = true;

    // Protect PHP Code from being stripped when moving to source mode
    config.entities = false;
    config.basicEntities = false;
    config.entities_additional = '';
    config.returnOutput = true;
    config.forceSimpleAmpersand = false;


    config.extraPlugins = 'widget,basewidget,notification,notificationaggregator,embedbase,embed,autoembed,dialogui,autosave';
    config.clipboard_defaultContentType = 'text';
    

    config.autosave_NotOlderThen = 720; //1440-one day
    config.autosave_delay = 1800; //in seconds, 1800 = 30 min
    config.autosave_saveDetectionSelectors = "a[id*='btn_tab_save'],a[id*='btn_tab_save_stay'],a[id*='btn_tab_cancel']"; 


    config.toolbar_Full =
    [
        ['Bold','Italic','Underline','Strike','-','Subscript','Superscript'],[ 'TransformTextToUppercase', 'TransformTextToLowercase', 'TransformTextCapitalize', 'TransformTextSwitcher' ],
        ['Styles','Format','Font','FontSize','lineheight'],['TextColor','BGColor'],['Maximize','ShowBlocks'],['Nbsp'],['Link','Unlink','Anchor'],['Image','image2'],['FontAwesome','Glyphicons','GoogleMaps','leaflet','ImageMaps','addFile','addImage'],['strinsert'],'/',
        ['Source','searchCode','autoFormat','CommentSelectedRange','UncommentSelectedRange','AutoComplete','-','NewPage','Preview','-','Templates'],
        ['Cut','Copy','Paste','PasteText','PasteFromWord','inserthtml','-','Print','SpellChecker','Scayt'],
        ['Undo','Redo','-','Find','Replace','-','SelectAll','RemoveFormat'],
        ['CreatePlaceholder','AddLayout'],
        ['dewplayer','Youtube','Vimeo','Video','jwplayer','oembed','Flash'],['highslide','Slideshow','fileicon'],['geshi','qrcodes','Language','EqnEditor','simplebutton'],
        ['Form','Checkbox','Radio','TextField','Textarea','Select','Button','ImageButton','HiddenField'],['NumberedList','BulletedList','-','Outdent','Indent','Blockquote','CreateDiv'],
        ['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
        ['BidiLtr','BidiRtl'],
        ['Table','HorizontalRule','Smiley','SpecialChar','PageBreak','Iframe']
    ];

    config.toolbar_Middle =
    [
        ['Bold','Italic','Underline','Strike','-','Subscript','Superscript'],[ 'TransformTextToUppercase', 'TransformTextToLowercase', 'TransformTextCapitalize', 'TransformTextSwitcher' ],
        ['Styles','Format','Font','FontSize'],['TextColor','BGColor'],['Maximize','ShowBlocks'],['Nbsp'],['Link','Unlink','Anchor'],['Image','image2'],'/',
        ['Source','searchCode','autoFormat','CommentSelectedRange','UncommentSelectedRange','AutoComplete','-','NewPage','Preview','-','Templates'],
        ['Cut','Copy','Paste','PasteText','PasteFromWord','inserthtml','-','Print','SpellChecker','Scayt'],
        ['Undo','Redo','-','Find','Replace','-','SelectAll','RemoveFormat'],
        ['NumberedList','BulletedList','-','Outdent','Indent','Blockquote','CreateDiv'],
        ['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
        ['BidiLtr','BidiRtl'],
        ['Table','HorizontalRule','Smiley','SpecialChar','PageBreak','Iframe','base64image','simplebutton']
    ];

    config.toolbar_Textformat =
    [
        ['Bold','Italic','Underline','Strike'],[ 'TransformTextToUppercase', 'TransformTextToLowercase', 'TransformTextCapitalize', 'TransformTextSwitcher' ],[ 'TransformTextToUppercase', 'TransformTextToLowercase', 'TransformTextCapitalize', 'TransformTextSwitcher' ],
        ['Styles','Format','Font','FontSize'],['TextColor','BGColor'],['Nbsp']
    ];

    config.toolbar_Basic =
    [
        ['Bold','Italic','Underline','Strike'],[ 'TransformTextToUppercase', 'TransformTextToLowercase', 'TransformTextCapitalize', 'TransformTextSwitcher' ],[ 'TransformTextToUppercase', 'TransformTextToLowercase', 'TransformTextCapitalize', 'TransformTextSwitcher' ],
        ['Image','Link','Unlink'],['Styles','Format','Font','FontSize'],['TextColor','BGColor'],['Nbsp']
    ];
    config.toolbar_Basic1 =
    [
        ['Bold','Italic','Underline','Strike'],['Link','Unlink'],[ 'TransformTextToUppercase', 'TransformTextToLowercase', 'TransformTextCapitalize', 'TransformTextSwitcher' ],['Nbsp']
    ];
    config.toolbar_Basic2 =
    [
        ['Bold','Italic','Underline','Strike'],['Image','Link','Unlink'],['TextColor','BGColor'],[ 'TransformTextToUppercase', 'TransformTextToLowercase', 'TransformTextCapitalize', 'TransformTextSwitcher' ],['Source'],['Nbsp']
    ];
    config.toolbar_Basic3 =
    [
        ['Bold','Italic','Underline','Strike'],['Image','Link','Unlink'],['TextColor','BGColor'],['Source'],['Nbsp']
    ];
    config.toolbar_Basic4 =
    [
        ['Bold','Italic','Underline','Strike'],['Image','Link','Unlink'],['TextColor','BGColor'],['Styles','Format','Font','FontSize'],['Table'],['Nbsp'],['Source']
    ];
    config.toolbar_Basic5 =
    [
        ['Bold','Italic','Underline','Strike'],['NumberedList','BulletedList'],['TextColor','BGColor'],['Source'],['Styles','Format','Font','FontSize'],['Nbsp'],['Youtube','Vimeo','Video','jwplayer','oembed']
    ];
    config.toolbar_Articleprefix =
    [
        ['Bold','Italic','Underline','Strike'],['Image','Link','Unlink'],['TextColor','BGColor'],['Styles','FontSize'],[ 'TransformTextToUppercase', 'TransformTextToLowercase', 'TransformTextCapitalize', 'TransformTextSwitcher' ],['Nbsp'],['Source']
    ];
    config.toolbar_Empty =
    [
        []
    ];

    config.toolbar_Front1 =
    [
        ['Bold','Italic','Underline','Strike'],['Link','Unlink'],['TextColor','BGColor'],['Styles','Format','Font','FontSize'],['Nbsp']
    ];
    config.toolbar_Demo =
    [
        ['Source','searchCode','autoFormat','CommentSelectedRange','UncommentSelectedRange','AutoComplete','-','NewPage','Preview','-','Templates'],
        ['Cut','Copy','Paste','PasteText','PasteFromWord','inserthtml','-','Print','SpellChecker','Scayt'],
        ['Undo','Redo','-','Find','Replace','-','SelectAll','RemoveFormat'],
        ['Form','Checkbox','Radio','TextField','Textarea','Select','Button','ImageButton','HiddenField'],
        ['NumberedList','BulletedList','-','Outdent','Indent','Blockquote','CreateDiv'],
        ['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
        ['BidiLtr','BidiRtl'],['Link','Unlink','Anchor'],
        ['addFile','addImage','Image','Flash','Table','HorizontalRule','Smiley','SpecialChar','PageBreak','Iframe'],['nbsp'],
        ['Bold','Italic','Underline','Strike','-','Subscript','Superscript'],[ 'TransformTextToUppercase', 'TransformTextToLowercase', 'TransformTextCapitalize', 'TransformTextSwitcher' ],
        ['Styles','Format','Font','FontSize'],['TextColor','BGColor'],['Maximize','ShowBlocks']
    ];
    config.toolbar = 'Full';

};

/**
 * Override the default 'toolbarCollapse' command to hide
 * only toolbars in the row two and onwards.
 */
CKEDITOR.on('instanceReady', function(e) {

    function switchVisibilityAfter1stRow(toolbox, show)
    {
        if(toolbox===undefined) {return;}
        var inFirstRow = true;
        var elements = toolbox.getChildren();
        var elementsCount = elements.count();
        var elementIndex = 0;
        var element = elements.getItem(elementIndex);
        for (; elementIndex < elementsCount; element = elements.getItem(++elementIndex))  {
            inFirstRow = inFirstRow && !(element.is('span') && element.hasClass('cke_toolbar_break'));
            if (!inFirstRow)  {
                if (show) element.show(); else element.hide();
            }
        }
    }

    var editor = e.editor;
    var collapser = (function()  {
        try {
            // We've HTML: td.cke_top {
            //  div.cke_toolbox {span.cke_toolbar, ... }
            //  , a.cke_toolbox_collapser }
            var firstToolbarId = editor.toolbox.toolbars[0].id;
            var firstToolbar = CKEDITOR.document.getById(firstToolbarId);
            var toolbox = firstToolbar.getParent();
            var collapser = toolbox.getNext();
            return collapser;
        }
        catch (e) {}
    })();

    // Copied from editor/_source/plugins/toolbar/plugin.js & modified
    editor.addCommand( 'toolbarCollapse', {
        readOnly: 1,
        exec : function( editor ) {
            if (collapser === null ) return;//|| collapser===undefined

            var collapser = editor.ui.space( 'toolbar_collapser' );
            var toolbox;
            if(collapser!==undefined && collapser!==null) {toolbox = collapser.getPrevious();}
            var contents = editor.ui.space( 'contents' );
            var toolboxContainer;
            if(toolbox!==undefined && toolbox!==null) {toolboxContainer = toolbox.getParent();}
            var contentHeight = parseInt( contents.$.style.height, 10 );
            var previousHeight;
            if(toolboxContainer!==undefined) {previousHeight = toolboxContainer.$.offsetHeight;}
            var minClass = 'cke_toolbox_collapser_min';
            var collapsed;
            if(collapser!==undefined && collapser!==null) {collapsed = collapser.hasClass( minClass );}

            //collapsed = toolbox.hasClass('iterate_tbx_hidden');//!toolbox.isVisible();
            if(toolbox!==undefined && toolbox!==null) {collapsed = toolbox.hasClass('iterate_tbx_hidden');}

            if ( !collapsed ) {
                switchVisibilityAfter1stRow(toolbox, false);    // toolbox.hide();
                if(toolbox!==undefined && toolbox!==null) {
                    toolbox.addClass('iterate_tbx_hidden');
                    if (!toolbox.isVisible()) toolbox.show(); // necessary 1st time if initially collapsed
                }


                if(collapser!==null) {
                    collapser.addClass( minClass );
                    collapser.setAttribute( 'title', editor.lang.toolbar.toolbarExpand );
                }

            }
            else {
                switchVisibilityAfter1stRow(toolbox, true);    // toolbox.show();
                if(toolbox!==undefined && toolbox!==null) {toolbox.removeClass('iterate_tbx_hidden');}

                if(collapser!==null) {
                    collapser.removeClass( minClass );
                    collapser.setAttribute( 'title', editor.lang.toolbar.toolbarCollapse );
                }

            }

            // Update collapser symbol.
            if(collapser) {
                collapser.getFirst().setText( collapsed ? '\u25B2' : '\u25C0' );
            }

            if(toolboxContainer) {
                var dy = toolboxContainer.$.offsetHeight - previousHeight;
                contents.setStyle( 'height', ( contentHeight - dy ) + 'px' );
            }


            editor.fire( 'resize', {
                outerHeight: editor.container.$.offsetHeight,
                contentsHeight: contents.$.offsetHeight,
                outerWidth: editor.container.$.offsetWidth
            } );
        },

       modes: { wysiwyg: 1, source: 1 }
    } );

    // Make sure advanced toolbars initially collapsed
    editor.execCommand( 'toolbarCollapse' );
});