#####
#  FCKeditor - The text editor for internet
#  Copyright (C) 2003-2005 Frederico Caldeira Knabben
#  
#  Licensed under the terms of the GNU Lesser General Public License:
#  		http://www.opensource.org/licenses/lgpl-license.php
#  
#  For further information visit:
#  		http://www.fckeditor.net/
#  
#  File Name: FCKeditor.pm
#  	This is the integration file for Perl.
#  
#  File Authors:
#  		Takashi Yamaguchi (jack@omakase.net)
#
#  Modified and made into a package by: 
#		Doug Bierer (doug@unlikelysource.com)
#
#  Usage: 
#	1.	Put this command at the top of your PERL program:
#
#			use FCKeditor;
#
#	2.	Where you want to place the FCKeditor in your output,
#		call FCKeditor::create() as follows:
#
#		$html_string = FCKeditor::create($InstanceName,$BasePath);
#
#		This will produce an HTML string which effectively replaces
#		a <textarea name=$InstanceName></textarea> field in your form.
#		Note that there are a few other parameters which you can
#		specify in the create() call, noted below.  Height and 
#		width, for example.
#
#		You can then integrate this HTML code directly into your
#		Output.  For example:
#
#		use FCKeditor;
#		print 'content-type: text/html\n\n';
#		print '<html><body><form method=get action="this.pl">';
#		print '<p>Enter Your Message Here:</p>';
#		print FCKeditor::create();
#		print '<input type=submit name="OK" value="OK">';
#		print '</form></body></html>';
#
#		Or you could send the string to the Template module, 
#		depending on how you output your HTML.  Your return CGI
#		program will then look for a parameter "editor", which is
#		the default (see $InstanceName).
#
#####

package FCKeditor;

require Exporter;

#---------------------------------------------------------------------------------

our $VERSION = 0.01;

our @ISA = ("Exporter");

our @EXPORT = qw(
	&FCKeditor 
	&Create
	&specialchar_cnv
	&CreateHtml
	&IsCompatible
	&GetConfigFieldString
	&new
	);

our %EXPORT_TAGS = ( );

our @EXPORT_OK = qw(
	$InstanceName
	$BasePath
	$Width
	$Height
	$ToolbarSet
	$Value
	%Config
	);

use vars qw(
	$InstanceName
	$BasePath
	$Width
	$Height
	$ToolbarSet
	$Value
	%Config
	);

#---------------------------------------------------------------------------------
	
# Initialize Globals


$InstanceName	= 'editor';
$BasePath		= './FCKeditor/';
$Height			= '400';
$Width			= '100%';
$ToolbarSet		= 'Default';
$Value			= '';
%Config 		= ( );

#---------------------------------------------------------------------------------

#
# Inputs: 	$InstanceName = the <textarea> field you want to replace with FCKeditor output
#			$BasePath = the directory where the FCKeditor files reside
#			$Height = height you want FCKeditor to reach
#			$Width = width you wish FCKeditor to take
#			$ToolbarSet = any special set of tools 
#			$Value = ???
#
# Outputs:	An HTML string which implements FCKeditor
#
sub Create
{

	$InstanceName 	= shift;
	$BasePath 		= shift;
	$Height			= shift;
	$Width			= shift;
	$ToolbarSet		= shift;
	$Value			= shift;

	# Check to see if null and reset to original values
	if ( !$InstanceName ) { $InstanceName 	= "editor"; 		}
	if ( !$BasePath		) { $BasePath		= './FCKeditor/'; 	}
	if ( !$Height		) { $Height			= '400'; 			}
	if ( !$Width		) { $Width			= '100%';			}
	if ( !$ToolbarSet	) { $ToolbarSet		= 'Default';		}

	return &CreateHtml();

}

sub specialchar_cnv
{

	local($ch) = @_;

	$ch =~ s/&/&amp;/g;		# &
	$ch =~ s/\"/&quot;/g;	#"
	$ch =~ s/\'/&#39;/g;	# '
	$ch =~ s/</&lt;/g;		# <
	$ch =~ s/>/&gt;/g;		# >
	return($ch);
}

sub CreateHtml
{

	$HtmlValue = &specialchar_cnv($Value);
	$Html = '<div>' ;
	if(&IsCompatible()) {
		$Link = $BasePath . "editor/fckeditor.html?InstanceName=$InstanceName";
		if($ToolbarSet ne '') {
			$Link .= "&amp;Toolbar=$ToolbarSet";
		}
		#// Render the linked hidden field.
		$Html .= "<input type=\"hidden\" id=\"$InstanceName\" name=\"$InstanceName\" value=\"$HtmlValue\" />" ;

		#// Render the configurations hidden field.
		$cfgstr = &GetConfigFieldString();
		$wk = $InstanceName."___Config";
		$Html .= "<input type=\"hidden\" id=\"$wk\" value=\"$cfgstr\" />" ;

		#// Render the editor IFRAME.
		$wk = $InstanceName."___Frame";
		$Html .= "<iframe id=\"$wk\" src=\"$Link\" width=\"$Width\" height=\"$Height\" frameborder=\"no\" scrolling=\"no\"></iframe>";
	} else {
		if($Width =~ /\%/g){
			$WidthCSS = $Width;
		} else {
			$WidthCSS = $Width . 'px';
		}
		if($Height =~ /\%/g){
			$HeightCSS = $Height;
		} else {
			$HeightCSS = $Height . 'px';
		}
		$Html .= "<textarea name=\"$InstanceName\" rows=\"4\" cols=\"40\" style=\"width: $WidthCSS; height: $HeightCSS\" wrap=\"virtual\">$HtmlValue</textarea>";
	}
	$Html .= '</div>';
	return($Html);
}

sub IsCompatible
{

	$sAgent = $ENV{'HTTP_USER_AGENT'};
	if(($sAgent =~ /MSIE/i) && !($sAgent =~ /mac/i) && !($sAgent =~ /Opera/i)) {
		$iVersion = substr($sAgent,index($sAgent,'MSIE') + 5,3);
		return($iVersion >= 5.5) ;
	} elsif($sAgent =~ /Gecko\//i) {
		$iVersion = substr($sAgent,index($sAgent,'Gecko/') + 6,8);
		return($iVersion >= 20030210) ;
	} else {
		return(0);		# 2.0 PR fix
	}
}

sub GetConfigFieldString
{
	$sParams = '';
	$bFirst = 0;
	foreach $sKey (keys %Config) {
		$sValue = $Config{$sKey};
		if($bFirst == 1) {
			$sParams .= '&amp;';
		} else {
			$bFirst = 1;
		}
		$k = &specialchar_cnv($sKey);
		$v = &specialchar_cnv($sValue);
		if($sValue eq "true") {
			$sParams .= "$k=true";
		} elsif($sValue eq "false") {
			$sParams .= "$k=false";
		} else {
			$sParams .= "$k=$v";
		}
	}
	return($sParams);
}

1;
