/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.dialog.add( 'filebrowsertest', function( editor )
{
	return {
		title : 'Test plugin',
		minWidth : '520',
		minHeight : '540',
		contents : [
			{
				id : 'tab1',
				label : 'File Browser',
				accessKey : 'B',
				elements :
				[
					{
						type : 'vbox',
						children :
						[
							{
								type : 'html',
								html : '<div>Automatic association of filebrowser plugin based on element id</div>'
							},
							/**
							 * When filebrowser plugin is enabled and the following UI elements are available:
							 *  - browse
							 *  - url 
							 *  - uploadButton
							 * filebrowser plugin will automatically attach itself to the 'browse' and 'uploadButton' elements
							 * (if action is set to 'filebrowser') and the 'url' field will be updated when file is selected or uploaded.
							 */
							{
								type : 'hbox',
								children : 
								[
									{
										type : 'text',
										label : '',
										labelLayout : 'vertical',
										id : 'url'
									},
									{
										type : 'button',
										id : 'browse',
										label : editor.lang.common.browseServer
									}
								]
							},
							{
								type : 'hbox',
								align : 'left',
								padding : 0,
								children :
								[
									{
										type : 'file',
										action : 'filebrowser',
										label : editor.lang.common.upload,
										labelLayout : 'vertical',
										id : 'upload'
									},
									{
										type : 'fileButton',
										label : editor.lang.common.uploadSubmit,
										id : 'uploadButton',
										'for' : ['tab1', 'upload']
									}
								]
							},
							/**
							 * Manual integration using the filebrowser attribute.
							 */
							{
								type : 'html',
								html : '<div>API example</div>'
							},
							{
								type : 'html',
								html : '<div>Select File</div>'
							},
							{
								type : 'hbox',
								children : 
								[
									{
										type : 'text',
										label : '',
										labelLayout : 'vertical',
										id : 'id1'
									},
									{
										type : 'button',
										id : 'id0',
										label : editor.lang.common.browseServer,
										filebrowser :
										{
											action : 'Browse',
											updateOnSelect : ['tab1', 'id1']
										}
									}
								]
							},
							{
								type : 'hbox',
								align : 'left',
								padding : 0,
								children :
								[
									{
										type : 'file',
										label : editor.lang.common.upload,
										labelLayout : 'vertical',
										id : 'id2'
									},
									{
										type : 'fileButton',
										label : editor.lang.common.uploadSubmit,
										id : 'id3',
										filebrowser :
										{
											action : 'QuickUpload',
											params : { type : 'Files', currentFolder : '/' },
											updateOnUpload : ['tab1', 'id1']
										},
										'for' : ['tab1', 'id2']
									}
								]
							},
							{
								type : 'html',
								html : '<div>Select Image</div>'
							},
							{
								type : 'hbox',
								children : 
								[
									{
										type : 'text',
										label : '',
										labelLayout : 'vertical',
										id : 'id4'
									},
									{
										type : 'button',
										id : 'id5',
										label : editor.lang.common.browseServer,
										filebrowser : 
										{
											action : 'Browse',
											params : { type : 'Images', currentFolder : '/' },
											updateOnSelect : ['tab1', 'id4']
										}
									}
								]
							},
							{
								type : 'hbox',
								align : 'left',
								padding : 0,
								children :
								[
									{
										type : 'file',
										label : editor.lang.common.upload,
										labelLayout : 'vertical',
										id : 'id6'
									},
									{
										type : 'fileButton',
										label : editor.lang.common.uploadSubmit,
										id : 'id7',
										filebrowser : 
										{ 
											action : 'QuickUpload', 
											params : { type : 'Images', currentFolder : '/' }, 
											updateOnUpload : ['tab1', 'id4'],
											// This function will be executed when file upload is completed.
											onUpload : function( errorNumber, fileName, customErrorMsg ) 
											{ 
												alert( 'Upload complete. ' + '\n' +
														'Error number: ' + errorNumber + '\n' +
														'File name:    ' + fileName + '\n' +
														'Error message: ' + customErrorMsg );
												// Do not call the built-in onUpload command 
												// return false;
											}
										},
										'for' : ['tab1', 'id6']
									}
								]
							},
							{
								type : 'html',
								html : '<div>CKFinder (external browser) integration</div>'
							},
							{
								type : 'hbox',
								children : 
								[
									{
										type : 'text',
										label : '',
										labelLayout : 'vertical',
										id : 'id10'
									},
									{
										type : 'button',
										id : 'id11',
										label : editor.lang.common.browseServer,
										filebrowser : 
										{
											action : 'Browse',
											url : '/ckfinder/ckfinder.html?action=js&func=SetUrl&thumbFunc=SetUrl&type=Images',
											updateOnSelect : ['tab1', 'id10']
										}
									}
								]
							},
							{
								type : 'hbox',
								align : 'left',
								padding : 0,
								children :
								[
									{
										type : 'file',
										label : editor.lang.common.upload,
										labelLayout : 'vertical',
										id : 'id12'
									},
									{
										type : 'fileButton',
										label : editor.lang.common.uploadSubmit,
										id : 'id13',
										filebrowser : 
										{ 
											action : 'QuickUpload', 
											url : '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
											updateOnUpload : ['tab1', 'id10'] 
										},
										'for' : ['tab1', 'id12']
									}
								]
							},
						]
					}
				]
			}
		],
		buttons : [ CKEDITOR.dialog.cancelButton ]
	};
} );
