﻿<?php
/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Configuration file for the File Manager Connector for PHP.
 */

global $Config ;

// SECURITY: You must explicitly enable this "connector". (Set it to "true").
$Config['Enabled'] = false ;


// Path to user files relative to the document root.
$Config['UserFilesPath'] = '/userfiles/' ;	// Set to / if you want filebrowsing across the whole site directory

// Fill the following value it you prefer to specify the absolute path for the
// user files directory. Useful if you are using a virtual directory, symbolic
// link or alias. Examples: 'C:\\MySite\\userfiles\\' or '/root/mysite/userfiles/'.
// Attention: The above 'UserFilesPath' must point to the same directory.
$Config['UserFilesAbsolutePath'] = '' ;	// Set to $_SERVER['DOCUMENT_ROOT'] if you want filebrowsing across the whole site

// Due to security issues with Apache modules, it is reccomended to leave the
// following setting enabled.
$Config['ForceSingleExtension'] = true ;

// What to do if a file being uploaded has the same name as an existing file on the server
// 	'renameold' - (default behaviour) backs up the version on the server to the same name + timestamp appended to the filename (after the extension)
//	'overwrite' - overwrites the version on the server with the same name
// 	'newname' - gives the uploaded file a new name (this was the (unconfigurable) behaviour in FCKeditor2.2)
// 	false - generates an error so that the file uploading fails
$Config['filenameClashBehaviour'] = 'renameold';

// In the following groupings:
//		'Subdirectory' is the subdirectory under the main 'UserFilesPath'
//			e.g. 'File/'
//			or leave it blank as '' to use the main UserFilesPath directory (i.e. the user can add files across the whole site)
//		'Regexp' ereg-style regexp which the name must validate to
//			This regexp applies to the part BEFORE the dot + file extension
//			e.g. '^([-_a-zA-Z0-9]{1,25})$'   (which would be sensible for best practice)
//			or leave it blank as '' for no checking

$Config['Subdirectory']['File']	= 'file/' ;
$Config['AllowedExtensions']['File']	= array() ;
$Config['DeniedExtensions']['File']		= array('html','htm','php','php2','php3','php4','php5','phtml','pwml','inc','asp','aspx','ascx','jsp','cfm','cfc','pl','bat','exe','com','dll','vbs','js','reg','cgi','htaccess','asis') ;
$Config['Regexp']['File']	= '' ;

$Config['Subdirectory']['Image']	= 'image/' ;
$Config['AllowedExtensions']['Image']	= array('jpg','gif','jpeg','png') ;
$Config['DeniedExtensions']['Image']	= array() ;
$Config['Regexp']['Image']	= '' ;

$Config['Subdirectory']['Flash']	= 'flash/' ;
$Config['AllowedExtensions']['Flash']	= array('swf','fla') ;
$Config['DeniedExtensions']['Flash']	= array() ;
$Config['Regexp']['Flash']	= '' ;

$Config['Subdirectory']['Media']	= 'media/' ;
$Config['AllowedExtensions']['Media']	= array('swf','fla','jpg','gif','jpeg','png','avi','mpg','mpeg') ;
$Config['DeniedExtensions']['Media']	= array() ;
$Config['Regexp']['Media']	= '' ;

?>