( function()
{
	load('scripts/trimpath.js');
	var CHANGELOG_TPL_PATH = "templates/changelog.tpl.html",
		CHANGELOG_OUTPUT_PATH = "CHANGES.html",
		TICKET_QUERY_CRITIRIAL = "status=closed&milestone=CKEditor 3.0&order=id&type=Bug&keywords=!~3.0RC&max=0";

	var namespace = new JavaImporter(
			org.apache.xmlrpc.XmlRpc,
			org.apache.xmlrpc.client,
			org.lustin.trac.xmlprc,
			java.net.URL,
			java.util,
			java.io.File,
			org.apache.commons.io.FileUtils,
			org.apache.commons["lang"].StringEscapeUtils );

	with ( namespace ) {
		// Tickets data. 
		var data = { tickets : [] };

		var conf = new XmlRpcClientConfigImpl();
		conf.setBasicUserName( "username" );
		conf.setBasicPassword( "password" );
		conf.setServerURL( new URL("http://dev.fckeditor.net/xmlrpc") );
		var client = new XmlRpcClient();
		client.setConfig( conf );
		var tracProxy = new TrackerDynamicProxy( client );
		var ticketAPI = tracProxy.newInstance( Ticket );
		var result = ticketAPI.query( TICKET_QUERY_CRITIRIAL );
		var iterator = result.iterator();
		while ( iterator.hasNext() )
		{
			var ticketId = iterator.next(),
				ticket = ticketAPI.get( ticketId ),
				ticketFields = ticket.get( 3 );
			print( "processing " + "#" + ticketId + " : " + ticketFields.get( "summary" ) );
			data.tickets.push(
				{ id : ticketId,
				  summary : StringEscapeUtils.escapeHtml( ticketFields.get( "summary" ) )
				} );
		}
		print( result.size() + ' tickets processed in total.' );

		var templateContent =
				FileUtils.readFileToString( new File( CHANGELOG_TPL_PATH ), 'utf-8' );
		
		var template = TrimPath.parseTemplate( String( templateContent ) );
		var result = template.process( data );

		FileUtils.writeStringToFile( new File( CHANGELOG_OUTPUT_PATH ), result, 'utf-8' );
	}

} )();

