<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:html="http://www.w3.org/1999/xhtml" xmlns="http://www.w3.org/1999/xhtml"
	exclude-result-prefixes="html">

	<xsl:output method="xml" indent="yes" />

	<xsl:template match="/">
		<html>
			<head>
				<title>Changelog - CKEditor</title>
				<meta http-equiv="content-type" content="text/html; charset=utf-8" />
				<style type="text/css">
				#footer hr {
					margin: 10px 0 15px 0;
					height: 1px;
					border: solid 1px gray;
					border-bottom: none;
				}

				#footer p {
					margin: 0 10px 10px 10px;
					float: left;
				}

				#footer #copy {
					float: right;
				}
				</style>
			</head>
		<body>
			<h1>CKEditor Changelog</h1>
			<h3>CKEditor 3.0 (SVN)</h3>
			<ul>
				<xsl:for-each select="//row[type/text()='Bug']">
				<xsl:sort select="id" data-type="number" order="descending"/>
					<li>
						<a target="_blank">
							<xsl:attribute name="href">http://dev.fckeditor.net/ticket/<xsl:value-of select="id" /></xsl:attribute>
							<xsl:text>#<xsl:value-of select="id" /></xsl:text>
						</a>: <xsl:value-of select="summary" />
					</li>
				</xsl:for-each>
			</ul>
			<div id="footer">
				<hr />
				<p>
					CKEditor - The text editor for Internet - <a href="http://ckeditor.com/">http://ckeditor.com</a>
				</p>
				<p id="copy">
					Copyright &#169; 2003-2009, <a href="http://cksource.com/">CKSource</a> - Frederico
					Knabben. All rights reserved.
				</p>
			</div>
		  </body>
		</html>
	</xsl:template>
</xsl:stylesheet>