﻿/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'hiddenfield', function( editor )
{
	return {
		title : editor.lang.hidden.title,
		minWidth : 350,
		minHeight : 110,
		onShow : function()
		{
			delete this.hiddenField;

			this.fakeObj = false;
			this.editMode = false;
			
			var selection = editor.getSelection();
			var element = selection.getSelectedElement();
			if ( element && element.getAttribute( '_cke_real_element_type' ) && element.getAttribute( '_cke_real_element_type' ) == 'hiddenfield' )
			{
				this.fakeObj = element;
				element = editor.restoreRealElement( this.fakeObj );
				this.hiddenField = element;
				this.editMode = true;
				this.setupContent(element);
				selection.selectElement( this.fakeObj );
			}
			
			this.getContentElement( 'info', '_cke_saved_name' ).focus();
		},
		onOk : function()
		{
			var name = this.getValueOf( 'info', '_cke_saved_name' ),
				value = this.getValueOf( 'info', 'value' ),
				element = CKEDITOR.env.ie ?
				editor.document.createElement( '<input type="hidden" name="' + CKEDITOR.tools.htmlEncode( name ) + '" value="' + CKEDITOR.tools.htmlEncode( value ) + '" >' ) :
				editor.document.createElement( 'input' );

			// Move contents and attributes of old anchor to new element.
			if ( this.editMode )
			{
				this.hiddenField.copyAttributes( element, { type: 1, name : 1, value : 1 } );
				this.hiddenField.moveChildren( element );
			}

			// Set name.
			element.removeAttribute( '_cke_saved_name' );
			element.setAttribute( 'name', name );
			
			
			if(value)
			{
				element.setAttribute( 'value', value );
			}else
			{
				element.removeAttribute( 'value' );
			}
			
			// Insert a new hidden
			var fakeElement = editor.createFakeElement( element, 'cke_hidden', 'hiddenfield' );
			if ( !this.editMode )
				editor.insertElement( fakeElement );
			else
			{
				fakeElement.replace( this.fakeObj );
				editor.getSelection().selectElement( fakeElement );
			}
			
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.hidden.title,
				title : editor.lang.hidden.title,
				elements : [
					{
						id : '_cke_saved_name',
						type : 'text',
						label : editor.lang.hidden.name,
						'default' : '',
						accessKey : 'N',
						setup : function( element )
						{
							this.setValue(
									element.getAttribute( '_cke_saved_name' ) ||
									element.getAttribute( 'name' ) ||
									'' );
						}
					},
					{
						id : 'value',
						type : 'text',
						label : editor.lang.hidden.value,
						'default' : '',
						accessKey : 'V',
						setup : function( element )
						{
							this.setValue( element.getAttribute( 'value' ) || '' );
						}
					}
				]
			}
		]
	};
});
