﻿/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'radio', function( editor )
{
	return {
		title : editor.lang.checkboxAndRadio.radioTitle,
		minWidth : 350,
		minHeight : 140,
		onShow : function()
		{
			delete this.radioButton;
			
			this.fakeObj = false;
			this.editMode = false;

			var selection = editor.getSelection();
			var element = selection.getSelectedElement();
			if ( element && element.getAttribute( '_cke_real_element_type' ) && element.getAttribute( '_cke_real_element_type' ) == 'radio' )
			{
				this.fakeObj = element;
				element = editor.restoreRealElement( this.fakeObj );
				//loadElements.apply( this, [ editor, selection, element ] );
				this.radioButton = element;
				this.editMode = true;
				this.setupContent(element);
				selection.selectElement( this.fakeObj );
			}
			
			this.getContentElement( 'info', 'name' ).focus();
		},
		onOk : function()
		{
			// Always create a new radio, because of IE BUG.
			var name = this.getValueOf( 'info', 'name' ),
				value = this.getValueOf( 'info', 'value' ),
				isChecked = !!this.getValueOf( 'info', 'checked' ),
				element = CKEDITOR.env.ie ?
				editor.document.createElement( '<input type="radio" name="' + CKEDITOR.tools.htmlEncode( name ) + '" value="' + CKEDITOR.tools.htmlEncode( value ) + '" '+ ( isChecked ? ' checked="checked"' : '' )+'>' ) :
				editor.document.createElement( 'input' );

			// Move contents and attributes of old anchor to new radio.
			if ( this.editMode )
			{
				this.radioButton.copyAttributes( element, { type: 1, name : 1, value : 1 } );
				this.radioButton.moveChildren( element );
			}

			// Set name.
			element.removeAttribute( '_cke_saved_name' );
			element.setAttribute( 'name', name );
			element.setAttribute( 'value', value );
			
			var type = 'cke_radio';
			
			if(!isChecked)
			{
				element.removeAttribute( 'checked' );
			}else
			{
				var type = 'cke_radio_checked';
				element.setAttribute( 'checked', 'checked' );
			}


			// Insert a new radio.
			var fakeElement = editor.createFakeElement( element, type, 'radio' );
			if ( !this.editMode )
				editor.insertElement( fakeElement );
			else
			{
				fakeElement.replace( this.fakeObj );
				editor.getSelection().selectElement( fakeElement );
			}
			
			return true;
			
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.checkboxAndRadio.radioTitle,
				title : editor.lang.checkboxAndRadio.radioTitle,
				elements : [
					{
						id : 'name',
						type : 'text',
						label : editor.lang.common.name,
						'default' : '',
						accessKey : 'N',
						setup : function( element )
						{
							this.setValue(
									element.getAttribute( '_cke_saved_name' ) ||
									element.getAttribute( 'name' ) ||
									'' );
						}
					},
					{
						id : 'value',
						type : 'text',
						label : editor.lang.checkboxAndRadio.value,
						'default' : '',
						accessKey : 'V',
						setup : function( element )
						{
							this.setValue( element.getAttribute( 'value' ) || '' );
						}
					},
					{
						id : 'checked',
						type : 'checkbox',
						label : editor.lang.checkboxAndRadio.selected,
						'default' : '',
						accessKey : 'S',
						value : "checked",
						setup : function( element )
						{
							this.setValue( element.getAttribute( 'checked' ) );
						}
					}
				]
			}
		]
	};
});
