﻿/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
// Our intention is force all formatting features to use CSS classes or
// semantic aware elements.
// Load our custom CSS files for this sample.
// We are using "BasePath" just for this sample convenience. In normal
// situations it would be just pointed to the file directly,
// like "/css/myfile.css".

CKEDITOR.editorConfig = function( config )
{

	config.contentsCss = CKEDITOR.basePath + 'custom-content.css';

	/**
	 * Core styles.
	 */
	config.coreStyles_bold			= { element : 'span', attributes : { 'class' : 'Bold' } } ;
	config.coreStyles_italic			= { element : 'span', attributes : { 'class' : 'Italic' } } ;
	config.coreStyles_underline		= { element : 'span', attributes : { 'class' : 'Underline' } } ;
	config.coreStyles_strike	= { element : 'span', attributes : { 'class' : 'StrikeThrough' } } ;

	/**
	 * Font face
	 */
	// List of fonts available in the toolbar combo. Each font definition is
	// separated by a semi-colon (;). We are using class names here, so each font
	// is defined by {Class Name}/{Combo Label}.
	config.font_names = 'FontComic/Comic Sans MS;FontCourier/Courier New;FontTimes/Times New Roman' ;

	// Define the way font elements will be applied to the document. The "span"
	// element will be used. When a font is selected, the font name defined in the
	// above list is passed to this definition with the name "Font", being it
	// injected in the "class" attribute.
	// We must also instruct the editor to replace span elements that are used to
	// set the font (overrides).
	config.font_style =
		{
			element		: 'span',
			attributes	: { 'class' : '#(font)' },
			overrides	: [ { element : 'span', attributes : { 'class' : /^Font(?:Comic|Courier|Times)$/ } } ]
		} ;

	/**
	 * Font sizes.
	 */
	config.fontSize_sizes		= 'FontSmaller/Smaller;FontLarger/Larger;FontSmall/8pt;FontBig/14pt;FontDouble/Double Size' ;
	config.fontSize_style =
		{
			element		: 'span',
			attributes	: { 'class' : 'Font#(size)' },
			overrides	: [ { element : 'span', attributes : { 'class' : /^Font(?:Smaller|Larger|Small|Big|Double)$/ } } ]
		} ;

	/**
	 * Font colors.
	 */
	config.colorButton_colors = 'FontColor1,FontColor2,FontColor3' ;
	config.colorButton_foreStyle =
		{
			element		: 'span',
			attributes	: { 'class' : '#(color)' },
			overrides	: [ { element : 'span', attributes : { 'class' : /^FontColor(?:1|2|3)$/ } } ]
		} ;

	config.colorButton_backStyle =
		{
			element		: 'span',
			attributes	: { 'class' : '#(color)BG' },
			overrides	: [ { element : 'span', attributes : { 'class' : /^FontColor(?:1|2|3)BG$/ } } ]
		} ;

	/**
	 * Indentation.
	 */
	config.indentClasses = [ 'Indent1', 'Indent2', 'Indent3' ] ;

	/**
	 * Paragraph justification.
	 */
	config.justifyClasses = [ 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyFull' ] ;
	
};
