﻿(function()
{
	function getListElement( editor, listTag ) {
		var range;
		try { range  = editor.getSelection().getRanges()[ 0 ]; }
		catch( e ) { return null; }
				
		range.shrink( CKEDITOR.SHRINK_TEXT );
		return range.getCommonAncestor().getAscendant( listTag, true );
	}
	
	function listStyle( editor, startupPage ) {
		if ( startupPage == 'bulletedListStyle' )
		{
			return {
				title : 'Bulleted List Properties',
				minWidth : 300,
				minHeight : 50,
				contents : [
					{
						elements :
						[
							{
								type : 'hbox',
								children :
								[
									{
										type : 'select',
										label : 'Type',
										width: '100px',
										items :
										[
											[ 'Circle' ],
											[ 'Disc' ],
											[ 'Square' ]
										],
										setup : function( element )
										{
											var value = element.getAttribute( 'type' ) || 'Disc';
											this.setValue( value );
										},
										commit : function( element )
										{
											element.setAttribute( 'type', this.getValue() );
										}
									}
								]
							}
						]
					}
				],
				onShow: function() 
				{
					var editor = this.getParentEditor(),
						element = getListElement( editor, 'ul' );
					
					element && this.setupContent( element );
				},
				onOk: function()
				{
					var editor = this.getParentEditor(),
						element = getListElement( editor, 'ul' );
					
					element && this.commitContent( element );
				}
			}
		}
		else if ( startupPage == 'numberedListStyle'  )
		{
			return {
				title : 'Numbered List Properties',
				minWidth : 300,
				minHeight : 50,
				contents : [
					{
						elements :
						[
							{
								type : 'hbox',
								widths : [ '25%', '75%' ],
								children :
								[
									{
										label: 'Start',
										type: 'text',
										setup : function( element )
										{
											var value = element.getAttribute( 'start' );
											value && this.setValue( value );
										},
										commit : function( element )
										{
											element.setAttribute( 'start', this.getValue() );
										}
									},
									{
										type : 'select',
										label : 'Type',
										width: '100%',
										items :
										[
											[ 'Numbers (1, 2, 3)', '1' ],
											[ 'Lowercase Letters (a, b, c)', 'a' ],
											[ 'Uppercase Letters (A, B, C)', 'A' ],
											[ 'Small Roman Numerals (i, ii, iii)', 'i' ],
											[ 'Large Roman Numerals (I, II, III)', 'I' ]
										],
										setup : function( element )
										{
											var value = element.getAttribute( 'type' ) || '1';
											this.setValue( value );
										},
										commit : function( element )
										{
											element.setAttribute( 'type', this.getValue() );
										}
									}
								]
							}
						]
					}
				],
				onShow: function() 
				{
					var editor = this.getParentEditor(),
						element = getListElement( editor, 'ol' );
					
					element && this.setupContent( element );
				},
				onOk: function()
				{
					var editor = this.getParentEditor(),
						element = getListElement( editor, 'ol' );
					
					element && this.commitContent( element );
				}
			}
		}
	};
	
	CKEDITOR.dialog.add( 'numberedListStyle', function( editor )
		{
			return listStyle( editor, 'numberedListStyle' );
		});

	CKEDITOR.dialog.add( 'bulletedListStyle', function( editor )
		{
			return listStyle( editor, 'bulletedListStyle' );
		});
})();