/*
 * File Name: nodePath\fckPlugin.js
 * 
 * Licensed under the terms of the GNU Lesser General Public License:
 * 		http://www.opensource.org/licenses/lgpl-license.php
 * 
 * 	Plugin for FCKeditor that shows a status bar with the path to the current selected node.
 *
 *  version 0.1 12/11/2005
 *		-initial release, just a nice status bar.
 *  version 0.2 21/03/2006 (Holger Hees)
 *		-extended release, with the ability to select elements from notelist.
 *  version 0.3 20/05/2006 (Holger Hees)
 *		-extended release, multi-editor ability
 *  version 0.5 14/06/2007 (Frdric Mestayer)
 *		-Added features (DOM access button for each elements)
 *		-Changed the selection behavior
 * 
 * File Authors:
 * 		Alfonso Martnez de Lizarrondo (Uritec) alfonso -at- uritec dot net
 *      Holger Hees hhees -at- systemconcept dot de
 *		Frdric Mestayer -at- fiducial dot fr
 */
var NodePathImg="images/clipboard.gif";
var FCKFakeSelect=null;

var StatusBar = function (editorInstance) {
	var td=document.createElement('TD');	
	td.id='statusBar';
	td.innerHTML='&nbsp;';
	td.style.fontFamily='Arial';
	td.style.fontSize='12px';
	td.style.backgroundColor='#efefde';
	td.style.paddingBottom="2px";
	td.style.paddingTop="2px";
	td.style.paddingLeft="2px";
	td.style.paddingRight="2px";
	td.style.border="solid 1px #696969";
	td.className='WYSIWYGPfad';
	var tr=document.createElement('TR');
	tr.appendChild(td);
	editorInstance.EditingArea.TargetElement.parentNode.parentNode.appendChild(tr);
	this.Bar = td;
	this.Instance = editorInstance;
	this.ArrayParents=new Array();

}

var sbNode=new Array();
//it should be part of the StatusBar object, but then I can't manage to get the event properly.
createStatusBar = function(oStatusBar) {

	//We should test if we are in source mode to hide the statusBar when necessary,
	//but i can't figure how to be notified of WYSIWYG=> Edit and Edit=>WYSIWYG so.... :/
	if (oStatusBar.Instance.EditMode==1)
	{
		oStatusBar.Bar.style.display=none;
		return;
	}else
	{
		oStatusBar.Bar.style.display='';
	}

	var node;
	var i=0;
	var text='&nbsp;'; 
	oStatusBar.ArrayParents=new Array();
   	var firstNode=false;
	
	//Test if we are recreating the path because of a click on the property button in the status bar.
	//This is a trick to force IE to select the proper node because it does not seems to handle it nicely
	if (FCKFakeSelect)
	{
		node=FCKFakeSelect;
	}else
	{
		node=oStatusBar.Instance.Selection.GetSelectedElement();
	}
	if (node) 
	{
		//You can't access attributes of fckfakeelements. Use the context menu of the editor instead.
		if (!node.getAttribute('_fckfakelement') )
		{
			text='<a href="javascript:viewSBElement(\''+oStatusBar.Instance.Name+'\','+i+')"><img src="'+NodePathImg+'" border=0></a>&nbsp;'+getNodeName(node,oStatusBar.Instance) + text;
		}else
		{
			text='&nbsp;'+getNodeName(node,oStatusBar.Instance) + text;
		}
	    firstNode=true;
		oStatusBar.ArrayParents.push(node);
		i++;
	}

	//parent, up to the body
	if (!node)	
	{
		node=oStatusBar.Instance.Selection.GetParentElement();
		if ((!node)&&(FCK.HasFocus))
		{
			//Hack to force IE to refresh the status bar when using keyboard to move the cursor
			node=oStatusBar.Instance.EditorDocument.selection.createRange().parentElement();
		}			
	}
	else
	{
		node=node.parentNode;		
	}
	
   	sbNode[oStatusBar.Instance.Name]=node;
	while (node && node.nodeName!='BODY') 
	{
		oStatusBar.ArrayParents.push(node);
	        if(firstNode) text = '&nbsp;&raquo;&nbsp;' + text;
		if (!node.getAttribute('_fckfakelement') )
		{
			text='<a href="javascript:viewSBElement(\''+oStatusBar.Instance.Name+'\','+i+')"><img src="'+NodePathImg+'" border=0></a>&nbsp;'+'<a href="javascript:selectSBElement(\''+oStatusBar.Instance.Name+'\','+i+')">'+getNodeName(node,oStatusBar.Instance)+'</a>' + text;
		}else
		{
			text='&nbsp;'+'<a href="javascript:selectSBElement(\''+oStatusBar.Instance.Name+'\','+i+')">'+getNodeName(node,oStatusBar.Instance)+'</a>' + text;
		}
		node=node.parentNode;
		firstNode=true;
        	i++;
	}

	//update the text
	if (text=='&nbsp;')
		oStatusBar.Bar.style.height='25px';
	else
		oStatusBar.Bar.style.height='';
	oStatusBar.Bar.innerHTML=text;
}

//Select a node in the editor area based on it's position in the hierarchy
function selectSBElement(instanceName,pos){
	node=statusBars[instanceName].ArrayParents[pos];   
	statusBars[instanceName].Instance.Selection.SelectNode(node);
	FCKFakeSelect=node;
        createStatusBar(statusBars[instanceName]);
	FCKFakeSelect=null;
}

//Select a node in the editor area
function selectSBNode(instanceName,node){	 
	statusBars[instanceName].Instance.Selection.SelectNode(node);
	FCKFakeSelect=node;//Trick so that this node will be selected when re-creating the node path
        createStatusBar(statusBars[instanceName]);
	FCKFakeSelect=null;
}

//auxiliary function to get the real name of the tag.
//It could be further improved.
getNodeName = function(oTag,instance) {
	var oRealTag;
	if (!oTag) 
		return "";

	if (oTag.getAttribute('_fckfakelement') )
		oRealTag = instance.GetRealElement( oTag ) ;
	else 
		oRealTag=oTag;

	var reg=new RegExp("( fck__showtableborders)", "g");
	var className='';
	var id='';
	if (oRealTag.className&&oRealTag.className!=''&&oRealTag.className.toLowerCase()!=' fck__showtableborders' )	
	{			
		className='.'+oRealTag.className.toLowerCase().replace(reg,"");
	}
	if (oRealTag.id&&oRealTag.id!='' )
		id='#'+oRealTag.id;
	//Tag name have this format :   tagname#tagId.tagClassName
	var sTagName=oRealTag.nodeName.toLowerCase()+id+className;
	return sTagName;
}

var statusBars = new Array();
function updateStatusBar(editorInstance){

	if(!statusBars[editorInstance.Name]){
		statusBars[editorInstance.Name]=new StatusBar(editorInstance);
	}
	else{
		createStatusBar(statusBars[editorInstance.Name]);
	}
}

//Click on a Tag's property button
function viewSBElement(instanceName,pos)
{	
	var reg=new RegExp("( FCK__ShowTableBorders)", "g");//Trick to remove the showtableBorder style attribute on tables
	
	var readonly=false;
	var node=statusBars[instanceName].ArrayParents[pos];

	//Get the real element if it's a fake one
	if (node.getAttribute('_fckfakelement') )
		node = FCK.GetRealElement( node) ;		

	//Clone the node so getting the real HTML won't break anything 
	//(before this on Gecko new tables would very small when viewing their properties
	var dummyNode=node.cloneNode(true);
	var sXHTML=FCKXHtml.GetXHTML( dummyNode, false, true) ;

	//Check if the innerHTML of the node is not editable
	var tag=node.nodeName.toLowerCase();
	if (tag=='tr'||tag=='img'||tag=='input'||tag=='embed'||tag=='hr'||tag=='tbody'||tag=='tfoot'||tag=='thead'||tag=='table')
		readonly=true;
	
	var stringread=" ";	
	var okread=	"var html = document.getElementById(\"innerElem\").value;"+
			"var originalHtml=document.getElementById(\"innerElemHidden\").value;"+
			"if (html!=originalHtml){"+
				"html=FCKConfig.ProtectedSource.Protect( html ) ;"+			
				"html = html.replace( FCKRegexLib.InvalidSelfCloseTags, \"$1></$2>\" ) ;"+
				"html = FCK.ProtectEvents( html ) ;"+
				"html = FCK.ProtectUrls( html ) ;"+
				"html = FCK.ProtectTags( html ) ;"+
				"self.editedElement.innerHTML=html;"+
				"FCKDocumentProcessor.Process( FCK.EditorDocument ) ;"+
				"FCK.Events.FireEvent( \"OnAfterSetHTML\" ) ;"+
			"}";
	var areacolor="";
	if (readonly)
	{
		stringread=" readonly='readonly' ";
		okread="";
		areacolor="background-color:#cccccc;";
	}

	var OKClicked="<script>function OKClicked()"+
		"{"+
			"var myid=document.getElementById(\"idElem\").value;"+
			"if (myid!=OriginalId)"+
			"{"+
				"self.editedElement.id=myid;"+
			"}"+
			okread+
			"var myclass=document.getElementById(\"classElem\").value;"+
			"if (myclass!=OriginalClass)"+
			"{"+
				"self.editedElement.className=myclass;"+
			"}"+
			"window.opener.selectSBNode(\""+instanceName+"\",self.editedElement);"+						"self.close();"+
		"}</script>";

	//Clicking the property button of a tag select this tag
	selectSBElement(instanceName,pos);	

	var win=window.open("","nom_popup","scrollbars=yes,resizable=yes,menubar=no, status=no,width=600, height=500");
	doc=win.document;

	doc.write("<HTML><HEAD>");
	doc.write(OKClicked);
	doc.write("<STYLE>body{font-family:Arial;font-size:11px;}.Button{border: #737357 1px solid;color: #3b3b1f;background-color: #c7c78f;}.PopupTitle{font-weight: bold;font-size: 14pt;color: #737357;background-color: #e3e3c7;padding: 3px 10px 3px 10px;}.PopupButtons{border-top: #d5d59d 1px solid;background-color: #e3e3c7;padding:7px 10px 7px 10px;}</STYLE>");
	doc.write("</HEAD><BODY style='margin: 0px;padding: 0px;' bgColor='#efefde'><TABLE height='100%' width='100%' border=0 cellspacing=0 cellpadding=0><TR class='PopupTitle' height='20px'><TD>");
	doc.write("Element "+node.nodeName);
	doc.write("</TD></TR><TR height='20px'><TD><TABLE border=0 cellspacing=0 cellpadding=0><TR><TD width='60px'>&nbsp;ID:</TD><TD><INPUT ID='idElem' VALUE='"+node.id+"' width='150px'></TD></TR></TABLE>");
	doc.write("</TD></TR><TR height='20px'><TD><TABLE border=0 cellspacing=0 cellpadding=0><TR><TD width='60px'>&nbsp;Class:</TD><TD><INPUT ID='classElem' VALUE='"+node.className.replace(reg,"")+"' width='150px'></TD></TR></TABLE>");
	doc.write("</TD></TR><TR height='20px'><TD><BR>&nbsp;InnerHTML");
	doc.write("</TD></TR><TR><TD><TEXTAREA "+stringread+" WRAP=VIRTUAL style='"+areacolor+"height:100%;width:100%;' ID='innerElem'>"+sXHTML+"</TEXTAREA><TEXTAREA style='display:none;' ID='innerElemHidden'>"+sXHTML+"</TEXTAREA>");
	doc.write("</TD></TR><TR height='20px' class='PopupButtons'><TD align=right><INPUT style='width:100px;' TYPE='BUTTON' VALUE='OK' onclick='javascript:OKClicked();' class='Button'>&nbsp;&nbsp;<INPUT TYPE='BUTTON' VALUE='Annuler' onclick='javascript:self.close();' class='Button' >");
	doc.write("</TD></TR></TABLE></BODY></HTML>");
	doc.close();
	win.editedElement=node;
	win.FCK=FCK;
	win.FCKConfig=FCKConfig;
	win.FCKRegexLib=FCKRegexLib;
	win.FCKDocumentProcessor=FCKDocumentProcessor;	
	win.OriginalId=node.id;
	win.OriginalClass=node.className.replace(reg,"");
	win.focus();
}

FCK.AttachToOnSelectionChange(updateStatusBar ) ;
FCK.Events.AttachEvent('OnStatusChange',updateStatusBar);
