﻿/*
Copyright (c) 2003-2010, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

/**
 * @file Forms Plugin
 */

CKEDITOR.plugins.add( 'forms',
{
	init : function( editor )
	{
		var lang = editor.lang;

		editor.addCss(
			'form' +
			'{' +
				'border: 1px dotted #FF0000;' +
				'padding: 2px;' +
			'}\n' );

		editor.addCss(
			'img.cke_hidden' +
			'{' +
				'background-image: url(' + CKEDITOR.getUrl( this.path + 'images/hiddenfield.gif' ) + ');' +
				'background-position: center center;' +
				'background-repeat: no-repeat;' +
				'border: 1px solid #a9a9a9;' +
				'width: 16px !important;' +
				'height: 16px !important;' +
			'}' );

		// All buttons use the same code to register. So, to avoid
		// duplications, let's use this tool function.
		var addButtonCommand = function( buttonName, commandName, dialogFile )
		{
			editor.addCommand( commandName, new CKEDITOR.dialogCommand( commandName ) );

			editor.ui.addButton( buttonName,
				{
					label : lang.common[ buttonName.charAt(0).toLowerCase() + buttonName.slice(1) ],
					command : commandName
				});
			CKEDITOR.dialog.add( commandName, dialogFile );
		};

		var dialogPath = this.path + 'dialogs/';
		addButtonCommand( 'Form',			'form',			dialogPath + 'form.js' );
		addButtonCommand( 'Checkbox',		'checkbox',		dialogPath + 'checkbox.js' );
		addButtonCommand( 'Radio',			'radio',		dialogPath + 'radio.js' );
		addButtonCommand( 'TextField',		'textfield',	dialogPath + 'textfield.js' );
		addButtonCommand( 'Textarea',		'textarea',		dialogPath + 'textarea.js' );
		addButtonCommand( 'Select',			'select',		dialogPath + 'select.js' );
		addButtonCommand( 'Button',			'button',		dialogPath + 'button.js' );
		addButtonCommand( 'ImageButton',	'imagebutton',	CKEDITOR.plugins.getPath('image') + 'dialogs/image.js' );
		addButtonCommand( 'HiddenField',	'hiddenfield',	dialogPath + 'hiddenfield.js' );

		// If the "menu" plugin is loaded, register the menu items.
		if ( editor.addMenuItems )
		{
			editor.addMenuItems(
				{
					form :
					{
						label : lang.form.menu,
						command : 'form',
						group : 'form'
					},

					checkbox :
					{
						label : lang.checkboxAndRadio.checkboxTitle,
						command : 'checkbox',
						group : 'checkbox'
					},

					radio :
					{
						label : lang.checkboxAndRadio.radioTitle,
						command : 'radio',
						group : 'radio'
					},

					textfield :
					{
						label : lang.textfield.title,
						command : 'textfield',
						group : 'textfield'
					},

					hiddenfield :
					{
						label : lang.hidden.title,
						command : 'hiddenfield',
						group : 'hiddenfield'
					},

					imagebutton :
					{
						label : lang.image.titleButton,
						command : 'imagebutton',
						group : 'imagebutton'
					},

					button :
					{
						label : lang.button.title,
						command : 'button',
						group : 'button'
					},

					select :
					{
						label : lang.select.title,
						command : 'select',
						group : 'select'
					},

					textarea :
					{
						label : lang.textarea.title,
						command : 'textarea',
						group : 'textarea'
					}
				});
		}

		// If the "contextmenu" plugin is loaded, register the listeners.
		if ( editor.contextMenu )
		{
			editor.contextMenu.addListener( function( element )
				{
					if ( element && element.hasAscendant( 'form', true ) && !element.isReadOnly() )
						return { form : CKEDITOR.TRISTATE_OFF };
				});

			editor.contextMenu.addListener( function( element )
				{
					if ( element && !element.isReadOnly() )
					{
						// replace IF statements with switch
						switch(element.getName())
						{
							case 'select' :
								return { select : CKEDITOR.TRISTATE_OFF };
							
							case 'textarea' :
								return { textarea : CKEDITOR.TRISTATE_OFF };
							
							case 'input' :

								// IE sometimes does not set the type attribute,
								// use element.$.type instead of element.getAttribute('type')
								switch(element.$.type)
								{
									case 'text' :
									case 'password' :
										return { textfield : CKEDITOR.TRISTATE_OFF };
									
									case 'button' :
									case 'submit' :
									case 'reset' :
										return { button : CKEDITOR.TRISTATE_OFF };
									
									case 'checkbox' :
										return { checkbox : CKEDITOR.TRISTATE_OFF };
									
									case 'radio' :
										return { radio : CKEDITOR.TRISTATE_OFF };
									
									case 'image' :
										return { imagebutton : CKEDITOR.TRISTATE_OFF };
								}

							// break for inputs of unrecognized types
							break;
							
							case 'img' :
								if(element.getAttribute( '_cke_real_element_type' ) === 'hiddenfield' )
								{
									return { hiddenfield : CKEDITOR.TRISTATE_OFF };
								}
						}
					}
				});
		}

		editor.on( 'doubleclick', function( evt )
			{
				var element = evt.data.element;

				// original used if/else statements each with a call to element.is()
				// lets use the more direct element.getName() in a switch since element.is() uses element.getName() internally
				switch(element.getName())
				{
					case 'form' :
						evt.data.dialog = 'form';
					break;

					case 'select' :
						evt.data.dialog = 'select';
					break;
					
					case 'textarea' :
						evt.data.dialog = 'textarea';
					break;
					
					case 'img' :
						if(element.getAttribute( '_cke_real_element_type' ) === 'hiddenfield' )
						{
							evt.data.dialog = 'hiddenfield';
						}
					break;
					
					case 'input' :
						// see note above for using element.$.type
						switch(element.$.type)
						{
							case 'text' :
							case 'password' :
								evt.data.dialog = 'textfield';
							break;

							case 'button' :
							case 'submit' :
							case 'reset' :
								evt.data.dialog = 'button';
							break;

							case 'checkbox' :
								evt.data.dialog = 'checkbox';
							break;

							case 'radio' :
								evt.data.dialog = 'radio';
							break;

							case 'image' :
								evt.data.dialog = 'imagebutton';
							break;
						}
				}
			});
	},

	afterInit : function( editor )
	{
		var dataProcessor = editor.dataProcessor,
			htmlFilter = dataProcessor && dataProcessor.htmlFilter,
			dataFilter = dataProcessor && dataProcessor.dataFilter;

		// Cleanup certain IE form elements default values.
		if ( CKEDITOR.env.ie )
		{
			htmlFilter && htmlFilter.addRules(
			{
				elements :
				{
					input : function( input )
					{
						var attrs = input.attributes,
							type = attrs.type;
						if ( type == 'checkbox' || type == 'radio' )
							attrs.value == 'on' && delete attrs.value;
					}
				}
			} );
		}

		if ( dataFilter )
		{
			dataFilter.addRules(
			{
				elements :
				{
					input : function( element )
					{
						if ( element.attributes.type == 'hidden' )
							return editor.createFakeParserElement( element, 'cke_hidden', 'hiddenfield' );
					}
				}
			} );
		}
	},
	requires : [ 'image', 'fakeobjects' ]
} );

if ( CKEDITOR.env.ie )
{
	CKEDITOR.dom.element.prototype.hasAttribute = function( name )
	{
		var $attr = this.$.attributes.getNamedItem( name );

		if ( this.getName() == 'input' )
		{
			switch ( name )
			{
				case 'class' :
					return this.$.className.length > 0;
				case 'checked' :
					return !!this.$.checked;
				case 'value' :
					var type = this.getAttribute( 'type' );
					if ( type == 'checkbox' || type == 'radio' )
						return this.$.value != 'on';
					break;
				default:
			}
		}

		return !!( $attr && $attr.specified );
	};
}
