#!/usr/bin/env python
"""
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * This is the "File Uploader" for Python (Standalone CGI and WSGI).
 *
 * Tested with:
 *  - Apache/2.2.3 (Win32) mod_python/3.2.10 Python/2.5 
 *  - Apache/2.2.3 (Debian Etch) mod_python/3.2.10 Python/2.4.4 
 *
 * You shouldn't need to make any change to this file, instead see
 *  config.py and .htaccess
 *
"""
import config as Config

import cgi
import cgitb; cgitb.enable()
import os, sys, re
try: # Windows needs stdio set for binary mode.
	import msvcrt
	msvcrt.setmode (0, os.O_BINARY) # stdin  = 0
	msvcrt.setmode (1, os.O_BINARY) # stdout = 1
except ImportError:
	pass

def WSGIApp(environ, start_response): # entry point

	# This is the function that sends the results of the uploading process 
	# WSGI compilant (generator)
	def SendResults( errorNumber, fileUrl = '', fileName = '', customMsg = '' ):
		yield """<script type="text/javascript">
			window.parent.OnUploadCompleted(%(errorNumber)s,"%(fileUrl)s","%(fileName)s","%(customMsg)s"); 
			</script>""" % {
			'errorNumber': errorNumber,
			'fileUrl': fileUrl.replace ('"', '\\"'),
			'fileName': fileName.replace ( '"', '\\"' ) , 
			'customMsg': customMsg.replace ( '"', '\\"' ),
			}
	
	def GetRootPath():
		# WARNING: this is not be thread safe, and doesn't work w/ VirtualServer/mod_python
		# Use Config.UserFilesAbsolutePath instead
		if environ.has_key('DOCUMENT_ROOT'):
			return environ['DOCUMENT_ROOT']
		else:
			sRealPath = os.path.realpath( './' ) 
			sSelfPath = environ['SCRIPT_FILENAME']
			sSelfPath = sSelfPath [ :  sSelfPath.rfind( '/' ) ] 
			sRealPath = sRealPath [ : len(sRealPath) - len(sSelfPath) ]
			return sRealPath


	# Start WSGI response:
	start_response ("200 Ok",[("Content-type","text/html")])
	
	# Check if this uploader has been enabled.
	if not Config.Enabled:	
		return SendResults( '1', '', '', 'This file uploader is disabled. Please check the "editor/filemanager/upload/py/config.py" file' )

	# Get the posted form data
	oForm = cgi.FieldStorage(fp=environ['wsgi.input'],
							environ=environ,
							keep_blank_values=1)

	# Check if the file has been correctly uploaded.
	if not oForm.has_key('NewFile') or not oForm['NewFile'].file:
		return SendResults( '202' ) 

	# Get the posted file.
	oFile = oForm['NewFile']

	# Get the uploaded file name extension.
	sFileName = oFile.filename

	# Replace dots in the name with underscores (only one dot can be there... security issue).
	if ( Config.ForceSingleExtension ):
		sFileName = re.sub( r'\.(?![^.]*$)', '_', sFileName ) 
	
	sFileName = sFileName.replace('\\','/')			# convert windows to unix path
	sFileName = os.path.basename (sFileName)	# strip directories
	sOriginalFileName = sFileName ;

	# Get the extension.
	sExtension = sFileName[ sFileName.rfind('.') + 1 : ]
	sExtension = sExtension.lower

	# The the file type (from the QueryString, by default 'File').
	sType = oForm.has_key('Type') and oForm('Type') or 'File' 

	# Check if it is an allowed type.
	if not sType in ('File','Image','Flash','Media'):
		return SendResults( 1, '', '', 'Invalid type specified' ) 

	# Get the allowed and denied extensions arrays.
	arAllowed	= Config.AllowedExtensions[sType] ;
	arDenied	= Config.DeniedExtensions[sType] ;

	# Check if it is an allowed extension.
	if ( len(arAllowed) > 0 and not sExtension in arAllowed  ) or ( len(arDenied) > 0 and sExtension in arDenied ):
		return SendResults( '202' )

	sErrorNumber	= '0' ;
	sFileUrl	= '' ;

	# Initializes the counter used to rename the file, if another one with the same name already exists.
	iCounter = 0 

	# Get the target directory.
	if ( Config.UserFilesAbsolutePath ):
		sServerDir = Config.UserFilesAbsolutePath[sType]
	else:
		sServerDir = GetRootPath() + Config.UserFilesPath[sType]

	if ( Config.UseFileType ):
		sServerDir = sServerDir + sType + '/' 

	while True:
		# Compose the file path.
		sFilePath = sServerDir + sFileName 

		# If a file with that name already exists.
		if os.path.exists( sFilePath ):
			iCounter+=1
			sFileName = sOriginalFileName.replace('.','(%d).' % iCounter ) 
			sErrorNumber = '201' 
		else:
			# Read file contents and write to the desired path (similar to php's move_uploaded_file)
			fout = file(sFilePath, 'wb')
			while 1:
				chunk = oFile.file.read(100000)
				if not chunk: break
				fout.write (chunk)
			fout.close()

			if os.path.exists ( sFilePath ):
				oldumask = os.umask(0) 
				os.chmod( sFilePath, 0755 ) 
				os.umask( oldumask ) 

			if ( Config.UseFileType ):
				sFileUrl = Config.UserFilesPath[sType] + sType + '/' + sFileName
			else:
				sFileUrl = Config.UserFilesPath[sType] + sFileName

			break

	return SendResults ( sErrorNumber, sFileUrl, sFileName ) ;



# Running from command line (CGI), in case of no mod_python nor wsgi server available
if __name__ == '__main__':
	try:
		import cgi2wsgi
		cgi2wsgi.run(WSGIApp)     # (call cgi to wsgi wrapper to execute WSGIApp)
	except:
		print "Content-Type: text/plain"
		print
		cgi.print_exception()
