﻿/*
Copyright (c) 2003-2010, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license


MDA 09/06/2010 - Added config variable, so enter key places in a <br /> statment.
DC  10/18/2010 - #145588 Added GSIHelp plugin
TLS 10/28/2010 - #112421 Added "Table" option to GSIBasic and GISResumeBasic
DC  05/31/2011 - #163244 Changed image preview text and remove advanced tabs from link and image dialogs
*/

CKEDITOR.editorConfig = function (config) {
    // Define changes to default configuration here. For example:
    // config.language = 'fr';
    // config.uiColor = '#AADC6E';
    // config.toolbar = 'Basic';

    //config.skin = 'v2';
    config.htmlEncodeOutput = false;
    config.enterMode = CKEDITOR.ENTER_BR;
    config.extraPlugins = 'GSIHelp';

    config.toolbar_GSIBasic = [
	    ['Format', 'Font', 'FontSize'],
	    ['Bold', 'Italic', 'Underline', 'RemoveFormat', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'NumberedList', 'BulletedList', '-', 'HorizontalRule', 'SpecialChar', 'Table'],
	    ['TextColor', '-', 'SelectAll', '-', 'Undo', 'Redo', '-', 'About', '-', 'GSIHelp']
    ];

    config.toolbar_GSIAdvance = [
    	['Source', '-', 'NewPage', 'Preview', '-', 'Templates'],
	    ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Print'],
	    ['Undo', 'Redo', '-', 'Find', 'Replace', '-', 'SelectAll'],
	    '/',
	    ['Bold', 'Italic', 'Underline', 'Strike', 'RemoveFormat', '-', 'Subscript', 'Superscript'],
	    ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent'],
	    ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'],
	    ['Link', 'Unlink', 'Anchor'],
	    ['Image', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar', 'PageBreak'],
	    '/',
	    ['Styles', 'Format', 'Font', 'FontSize'],
	    ['TextColor', 'BGColor'],
	    ['Maximize', '-', 'About', '-', 'GSIHelp']
    ];

    config.toolbar_GSIResumeBasic = [
	    ['Font', 'FontSize'],
	    ['Bold', 'Italic', 'Underline', 'RemoveFormat', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'NumberedList', 'BulletedList', '-', 'HorizontalRule', 'SpecialChar', 'Table', '-', 'TextColor', '-', 'SelectAll', '-', 'Undo', 'Redo', '-', 'About', '-', 'GSIHelp']
    ];

    config.image_previewText = ['This preview area allows you to modify your inserted image. You can resize the image by changing the width and height, add a border, or change the alignment of the image related to page text. Click the OK button when your inserted image is formatted as desired.'];

};

CKEDITOR.on('dialogDefinition', function (ev) {
    var dialogName = ev.data.name;
    var dialogDefinition = ev.data.definition;

    if (dialogName == 'link' || dialogName == 'image') {
        dialogDefinition.removeContents('advanced');
    }
});