CKEDITOR.plugins.add( 'ipad_tooltips', {
	init: function( editor ) {

		editor.ui.addButton( 'Tooltip', {
			label: 'Set Tooltip',
			command: 'setTooltip',
			icon: this.path + 'images/tooltipIcon.png'
		} );

		// detect double click on a tooltip element
		editor.on('doubleclick',function(event){
			var selected_block = editor.getSelection(),
				parent_element = selected_block.getStartElement();

			if (parent_element.hasClass('ipad_tooltip')) editor.execCommand('setTooltip');
		});

		CKEDITOR.dialog.add('setTooltipDialog', function(editor){
			return {
				title : 'Tooltip Properties',
				minWidth : 400,
				minHeight : 150,
				contents :
				[
					{
						id : 'general',
						label : 'Tooltip Properties',
						elements :
						[
						  	{
						 		type: 'html',
						 		html: 'This dialog allows you to set a tooltip for the selected text. Delete all text to remove the tooltip.'
						 	},
						 	{
							 	type: 'textarea',
							 	id: 'tooltip_content',
							 	label: 'Tooltip Contents',
							 	required: true
						 	}
						]
					}
				],
				onShow: function(){
					var selected_block = editor.getSelection(),
						parent_element = selected_block.getStartElement();

					if (parent_element.is('span')) this.getContentElement('general','tooltip_content').setValue(parent_element.getAttribute('title'));
				},
				onOk: function (){
					var dialog_string = this.getContentElement('general','tooltip_content').getValue(),
						parent_element = editor.getSelection().getStartElement(),
						selected_text = editor.getSelection().getSelectedText();

					if (dialog_string.length) {
						var edited_text = '<span class="ipad_tooltip" title="'+dialog_string+'">'+selected_text+'</title>';
						editor.insertHtml(edited_text);
					}
					else { // need to account for selection-by-double-click of > 1 word blocks so we select the entire parent element's contents
						selected_text = parent_element.getHtml();
						parent_element.remove();
						editor.insertText(selected_text);
					}
				}
			};
		});

		editor.addCommand( 'setTooltipDialogCall',new CKEDITOR.dialogCommand( 'setTooltipDialog' ));

		editor.addCommand( 'setTooltip', {
			exec : function( editor ) {
				var my_selection = editor.getSelection();

				if (!my_selection.getSelectedText().length) alert('You need to select some text for a tooltip to be applied.');
				else editor.execCommand('setTooltipDialogCall');
			}
		});

	}

} );
// editor.insertHTML
