$j.fn.panView = function (width, height, previewClientID) {
    return this.each(function () {

        var panViewWidthType = 'static';
        var panViewHeightType = 'static';
        var panId = this.id + "Pan";
        var panMaskId = this.id + "PanMask";
        var mouseState = 'up';
        var mouseStartX = 0;
        var mouseStartY = 0;
        var mouseDropX = 0;
        var mouseDropY = 0;
        var cssWidth;
        var cssHeight;
        var eThis = this;
        var preview_ClientID = previewClientID;
        // show image
        $j(this).css('display', 'block');

        //setTimeout("SetSomeDelay()", 500);
        //var bounds = new GetElementBounds(eThis);
        
        

        function MouseEvent(e) {
            this.e = e ? e : window.event;
            this.source = e.target ? e.target : e.srcElement;
            this.x = this.e.pageX ? this.e.pageX : this.e.clientX;
            this.y = this.e.pageY ? this.e.pageY : this.e.clientY;
            if (window.event) {
                this.x = (document.body.scrollLeft) ? this.x + document.body.scrollLeft : this.x;
                this.y = (document.body.scrollTop) ? this.y + document.body.scrollTop : this.y;
            }
        }

//        function GetElementBounds(o) {
//            this.width = o.clientWidth;
//            this.height = o.clientHeight;
//            this.minX = (width - this.width);
//            this.minY = (height - this.height);
//            this.maxX = 0;
//            this.maxY = 0;
//        }

        $j(this).wrap('<div id="' + panId + '" style="width:' + width + 'px; height:' + height + 'px; overflow:hidden; position: relative;"><div id="' + panMaskId + '" style="left:0px;top:0px;position:relative;"></div></div>');

        $j('div#' + panId).mousedown(function (e) {

            mouseState = 'down';

            var me = new MouseEvent(e);

            mouseStartX = me.x;
            mouseStartY = me.y;

            me = null;

            $j(this).css('cursor', 'move');

            return false
        });

        $j('div#' + panId).mouseup(function (e) {

            mouseState = 'up';

            mouseDropX = parseInt($j('div#' + panMaskId).get(0).style.left);
            mouseDropY = parseInt($j('div#' + panMaskId).get(0).style.top);
            $j(this).css('cursor', 'default');

        });

        $j(document.body).mousemove(function (e) {

            var me = new MouseEvent(e);

            var ePans = $j('div#' + panId);
            if (ePans == null) {
                return;
            }
            var ePan = ePans.get(0);

            if (ePan == undefined) {
                return;
            }
            // simple bound check.
            if (me.x < ePan.offsetLeft || me.x > (ePan.offsetLeft + width) || me.y < ePan.offsetTop || me.y > (ePan.offsetTop + height)) {
                mouseState = 'up';
            }

            if (mouseState == 'down') {

                var iLeft = mouseDropX - (mouseStartX - me.x);
                var iTop = mouseDropY - (mouseStartY - me.y);

                var bound_minX = (width - this.width);
                var bound_minY = (height - this.height);

                if (iLeft < bound_minX) {
                    iLeft = bound_minX;
                } else if (iLeft > 0) {
                    iLeft = 0;
                }

                if (iTop < bound_minY) {
                    iTop = bound_minY;
                } else if (iTop > 0) {
                    iTop = 0;
                }

                $j('div#' + panMaskId).css('left', iLeft + 'px').css('top', iTop + 'px');
                $j('#' + preview_ClientID).css('left', iLeft + 'px').css('top', iTop + 'px');
            }

            me = null;

            return false
        });

    });
};