﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Dialog windows operations.
 */

var FCKDialog = 
{
	BaseZIndex : 10000,
	LastSelectionData : null,
	DialogStack : []
} ;

// This method opens a dialog window using the standard dialog template.
FCKDialog.OpenDialog = function( dialogName, dialogTitle, dialogPage, width, height, customValue, parentWindow, resizable )
{
	// Setup the dialog info.
	var oDialogInfo = new Object() ;
	oDialogInfo.Title = dialogTitle ;
	oDialogInfo.Page = dialogPage ;
	oDialogInfo.Editor = window ;
	oDialogInfo.CustomValue = customValue ;		// Optional
	oDialogInfo.SelectionData = null ;

	if ( FCKBrowserInfo.IsIE )
	{
		var oSel = FCK.ToolbarSet.CurrentInstance.EditorDocument.selection ;
		var bInvalidRange = false ;

		if ( !oSel )
			bInvalidRange = true ;

		var oRange = oSel.createRange() ;
		if ( !oRange )
			bInvalidRange = true ;
		if ( oRange.parentElement && oRange.parentElement().ownerDocument != FCK.ToolbarSet.CurrentInstance.EditorDocument )
			bInvalidRange = true ;
		if ( oRange.item && oRange.item(0).ownerDocument != FCK.ToolbarSet.CurrentInstance.EditorDocument )
			bInvalidRange = true ;

		if ( bInvalidRange )
			oDialogInfo.SelectionData = this.LastSelectionData ;
		else
		{
			oDialogInfo.SelectionData = oRange ;
			this.LastSelectionData = oRange ;
		}
	}

	var sUrl = FCKConfig.BasePath + 'fckdialog.html' ;
	this.Show( oDialogInfo, dialogName, sUrl, width, height, parentWindow, resizable ) ;
}

FCKDialog.Show = function( dialogInfo, dialogName, pageUrl, dialogWidth, dialogHeight, parentWindow, resizable )
{
	var ownerWindow = FCK.ToolbarSet.CurrentInstance.Window.parent ;
	var ownerDocument = ownerWindow.document ;
	var scrollTop = ownerDocument.body.scrollTop ;
	var scrollLeft = ownerDocument.body.scrollLeft ;
	var innerWidth = FCKBrowserInfo.IsIE ? ownerDocument.documentElement.offsetWidth : ownerWindow.innerWidth ;
	var innerHeight = FCKBrowserInfo.IsIE ? ownerDocument.documentElement.offsetHeight : ownerWindow.innerHeight ;
	var iTop  = Math.max( scrollTop + ( innerHeight - dialogHeight - 20 ) / 2, 0 ) ;
	var iLeft = Math.max( scrollLeft + ( innerWidth - dialogWidth - 20 )  / 2, 0 ) ;
	if ( ! ownerWindow.FCKDialogArguments )
		ownerWindow.FCKDialogArguments = {} ;
	var dialogId = parseInt( Math.random() * 0x10000000, 10 ) ;
	ownerWindow.FCKDialogArguments[dialogId] = dialogInfo ;
	
	// The container will contain the following things:
	// 1. The dialog iframe
	// 2. The dialog shadow
	// 3. The dialog blocker (visible only when the dialog is disabled)
	var container = ownerDocument.createElement( 'div' ) ;
	container.dialogId = dialogId ;
	container.ownerWindow = ownerWindow ;
	dialogInfo.Dialog = container ;
	FCKDomTools.SetElementStyles( container, 
			{
				'position' : 'absolute',
				'top' : iTop + 'px',
				'left' : iLeft + 'px',
				'overflow' : 'visible',
				'zIndex' : this.BaseZIndex += 100
			} ) ;

	var frame = ownerDocument.createElement( 'iframe' ) ;
	frame.id = dialogId ;
	frame.frameBorder = 0 ;
	FCKDomTools.SetElementStyles( frame, 
			{ 
				'border' : 'none', 
				'position' : 'absolute',
				'top' : '6px',
				'left' : '6px',
				'zIndex' : '100'
			} ) ;
	ownerDocument.body.appendChild( container ) ;
	container.appendChild( frame ) ;
	this.ResizeDialog( container, dialogWidth, dialogHeight ) ;

	// Assigning frame.src directly does not work in Opera 9.5, need to use a timeout trick
	var loadFrame = function()
	{
		frame.src = pageUrl + '?dialogId=' + dialogId ;
	}
	setTimeout( loadFrame, 0 ) ;

	var oWindow = frame.contentWindow ;
	oWindow.focus() ;
	this.Window = oWindow ;

	// Keep record of the current dialog in the dialog stack, and enable dialog mode
	// if this is the first dialog in the dialog stack.
	if ( this.DialogStack.length == 0 )
		FCK.ToolbarSet.CurrentInstance.SetDialogMode( true ) ;
	else
		this.SetEnabled( this.DialogStack[ this.DialogStack.length - 1 ], false );
	this.DialogStack.push( container ) ;

	// Register drag handlers.
	this.InitDragHandlers( ownerWindow ) ;
	if ( ! this._RegisteredBlockerHandlers )
	{
		FCK.Events.AttachEvent( 'OnBackgroundBlockerLoaded', function( FCK, w ) { FCKDialog.RegisterDragHandlers( w ) ; } ) ;
		FCK.Events.AttachEvent( 'OnEditorBlockerLoaded', function( FCK, w ) { FCKDialog.RegisterDragHandlers( w ) ; } ) ;
		this._RegisteredBlockerHandlers = true ;
	}
}



// The following member functions should be called with a dialog container element as subject.
FCKDialog.ResizeDialog = function( container, width, height )
{
	FCKDomTools.SetElementStyles( container,
		{
			'width' : ( width + 20 ) + 'px',
			'height' : ( height + 20 ) + 'px'
		} ) ;
	this.RemoveShadow( container ) ;
	this.GenerateShadow( container ) ;
	var frame = container.getElementsByTagName( 'iframe' )[0] ;
	FCKDomTools.SetElementStyles( frame,
		{
			'width' : width + 'px',
			'height' : height + 'px'
		} ) ;
}

FCKDialog.RemoveShadow = function( container )
{
	var shadow = container.ownerDocument.getElementById( container.shadowId ) ;
	if ( shadow )
		shadow.parentNode.removeChild( shadow ) ;
}

FCKDialog.GenerateShadow = function( container )
{
	var doc = container.ownerDocument ;
	var shadowBlock = doc.createElement( 'div' ) ;
	shadowBlock.id = parseInt( Math.random() * 0x10000000 ) ;
	container.shadowId = shadowBlock.id ;
	FCKDomTools.SetElementStyles( shadowBlock,
		{
			'width' : container.offsetWidth + 'px',
			'height' : container.offsetHeight + 'px',
			'position' : 'absolute',
			'top' : '0px',
			'left' : '0px',
			'zIndex' : '0'
		} ) ;

	// 0 1 2
	// 3 4 5
	// 6 7 8
	var partUrl = 
	[
		'dialog.shadow.top.left.png',
		'dialog.shadow.top.png',
		'dialog.shadow.top.right.png',
		'dialog.shadow.left.png',
		'dialog.shadow.core.png',
		'dialog.shadow.right.png',
		'dialog.shadow.bottom.left.png',
		'dialog.shadow.bottom.png',
		'dialog.shadow.bottom.right.png'
	];
	var x = [ 0, 20, container.offsetWidth - 20 ] ;
	var y = [ 0, 20, container.offsetHeight - 20 ] ;
	for ( var i = 0 ; i < 9 ; i++ )
	{
		var d = doc.createElement( 'div' ) ;
		var modulo = i % 3 ;
		var quotient = parseInt( i / 3 ) ;
		if ( modulo % 2 == 0 )
			d.style.width = '20px' ;
		else
			d.style.width = ( container.offsetWidth - 40 ) + 'px' ;

		if ( quotient % 2 == 0 )
			d.style.height = '20px' ;
		else
			d.style.height = ( container.offsetHeight - 40 ) + 'px' ;
		FCKDomTools.LoadPNG( d, FCKConfig.SkinPath + 'images/' + partUrl[i] ) ;
		FCKDomTools.SetElementStyles( d,
			{
				'left' : x[modulo] + 'px',
				'top' : y[quotient] + 'px',
				'position' : 'absolute'
			} ) ;
		shadowBlock.appendChild( d ) ;
	}

	FCKDomTools.SetOpacity( shadowBlock, 0.65 ) ;
	container.appendChild( shadowBlock ) ;
}

FCKDialog.CloseDialog = function( container )
{
	var ownerWindow = container.ownerWindow ;
	var dialogId = container.dialogId ;
	delete ownerWindow.FCKDialogArguments[dialogId] ;
	container.parentNode.removeChild( container ) ;
	this.BaseZIndex -= 100 ;

	// Pop the dialog from the dialog stack, and disable dialog mode if the stack is empty.
	this.DialogStack.pop() ;
	if ( this.DialogStack.length == 0)
		FCK.ToolbarSet.CurrentInstance.SetDialogMode( false ) ;
	else
		this.SetEnabled( this.DialogStack[ this.DialogStack.length - 1 ], true ) ;

}

FCKDialog.SetEnabled = function( container, yes )
{
	var doc = container.ownerDocument ;
	if ( !yes )
	{
		if ( doc.getElementById( container.coverBlockId ) )
			return ;
		var coverBlock = doc.createElement( FCKBrowserInfo.IsIE ? 'div' : 'img' ) ;
		coverBlock.id = parseInt( Math.random() * 0x10000000, 10 ) ;
		container.coverBlockId = coverBlock.id ;
		FCKDomTools.SetElementStyles( coverBlock,
			{
				'width' : ( container.offsetWidth - 20 ) + 'px',
				'height' : ( container.offsetHeight - 20 ) + 'px',
				'left' : '6px',
				'top' : '6px',
				'position' : 'absolute',
				'zIndex' : 1000
			} ) ;
		if ( !FCKBrowserInfo.IsIE )
			coverBlock.src = FCKConfig.SkinPath + 'images/WindowCover.png' ;
		container.appendChild( coverBlock ) ;
		if ( FCKBrowserInfo.IsIE )
		{
			var spacer = doc.createElement( 'img' ) ;
			spacer.src = FCKConfig.BasePath + 'images/spacer.gif' ;
			FCKDomTools.SetElementStyles( spacer,
				{
					'width' : coverBlock.offsetWidth + 'px',
					'height' : coverBlock.offsetHeight + 'px',
					'position' : 'absolute',
					'left' : '0px',
					'top' : '0px'
				} ) ;
			coverBlock.appendChild( spacer ) ;

			var shadowBlock = doc.getElementById( container.shadowId );
			if ( shadowBlock )
				shadowBlock.style.display = 'none' ;
		}
		FCKDomTools.SetOpacity( container, 0.5 ) ;
	}
	else
	{
		var coverBlock = doc.getElementById( container.coverBlockId ) ;
		if ( coverBlock )
			coverBlock.parentNode.removeChild( coverBlock ) ;
		FCKDomTools.SetOpacity( container, 1.0 ) ;
		if ( FCKBrowserInfo.IsIE )
		{
			var shadowBlock = doc.getElementById( container.shadowId ) ;
			if ( shadowBlock )
				shadowBlock.style.display = '' ;
		}
	}
}

function _FCKDialog_Drag_Handlers()
{
	var _dragDialog = null ;
	var _ownerWindow = null ;
	var _lastCoords = null ;

	FCKDialog._GetMouseCoordinates = function( evt )
	{
		var element = evt.srcElement || evt.target ;
		var view = element.ownerDocument.parentWindow || evt.view ;
		var retval = { 'x': evt.clientX, 'y': evt.clientY };
		if ( view != _ownerWindow )
		{
			var offset = FCKTools.GetDocumentPosition( _ownerWindow, element.ownerDocument.documentElement ) ;
			retval.x += offset.x ;
			retval.y += offset.y ;
		}
		return retval ;
	}

	FCKDialog._DragMouseDownHandler = function( evt )
	{
		var view = null ;
		if ( !evt )
		{
			view = this.ownerDocument.parentWindow ;
			evt = view.event ;
		}
		else
			view = evt.view ;

		_dragDialog = view.dialogArguments.Dialog ;
		_lastCoords = FCKDialog._GetMouseCoordinates( evt ) ;
	}

	FCKDialog._DragMouseMoveHandler = function( evt )
	{
		if ( !_dragDialog )
			return ;
		if ( !evt )
			evt = this.ownerDocument.parentWindow.event ;

		var currentCoords = FCKDialog._GetMouseCoordinates( evt );
		var dx = currentCoords.x - _lastCoords.x;
		var dy = currentCoords.y - _lastCoords.y;
		_lastCoords = currentCoords;

		var x = parseInt( FCKDomTools.GetCurrentElementStyle( _ownerWindow, _dragDialog, 'left' ) ) + dx ;
		var y = parseInt( FCKDomTools.GetCurrentElementStyle( _ownerWindow, _dragDialog, 'top' ) ) + dy ;
		FCKDomTools.SetElementStyles( _dragDialog, 
			{
				'left' : x + 'px',
				'top' : y + 'px'
			} ) ;
	}

	FCKDialog._DragMouseUpHandler = function( evt )
	{
		if ( !_dragDialog )
			return ;
		if ( !evt )
			evt = this.ownerDocument.parentWindow.event ;
		_dragDialog = null ;
		_lastCoords = null ;
	}

	FCKDialog.RegisterDragHandlers = function( w )
	{
		if ( w._FCKDialogHandlersRegistered )
			return ;

		FCKTools.AddEventListener( w.document.documentElement, 'mousemove', this._DragMouseMoveHandler ) ;
		FCKTools.AddEventListener( w.document.documentElement, 'mouseup', this._DragMouseUpHandler ) ;
		w._FCKDialogHandlersRegistered = true ;
	}

	FCKDialog.InitDragHandlers = function( w )
	{
		if ( _ownerWindow )
			return ;
		_ownerWindow = w ;
		this.RegisterDragHandlers( w ) ;
	}
}
_FCKDialog_Drag_Handlers() ;
