/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Base class used by the FileBrowserConnector and Uploader.
 */

using System;

namespace FredCK.FCKeditorV2
{
	public abstract class FileWorkerBase : System.Web.UI.Page
	{
		private const string DEFAULT_USER_FILES_PATH = "/UserFiles/" ;

		private string sUserFilesPath ;
		private string sUserFilesDirectory ;

		protected string UserFilesPath
		{
			get
			{
				if ( sUserFilesPath == null )
				{
					// Try to get from the "Application".
					sUserFilesPath = (string)Application["FCKeditor:UserFilesPath"] ;

					// Try to get from the "Session".
					if ( sUserFilesPath == null || sUserFilesPath.Length == 0 )
					{
						sUserFilesPath = (string)Session["FCKeditor:UserFilesPath"] ;
						
						// Try to get from the Web.config file.
						if ( sUserFilesPath == null || sUserFilesPath.Length == 0 )
						{
							sUserFilesPath = System.Configuration.ConfigurationSettings.AppSettings["FCKeditor:UserFilesPath"] ;
							
							// Otherwise use the default value.
							if ( sUserFilesPath == null || sUserFilesPath.Length == 0 ) 
								sUserFilesPath = DEFAULT_USER_FILES_PATH ;
						}
					}

					// Check that the user path ends with slash ("/")
					if ( ! sUserFilesPath.EndsWith("/") )
						sUserFilesPath += "/" ;

					sUserFilesPath = this.ResolveUrl( sUserFilesPath ) ;
				}
				return sUserFilesPath ;
			}
		}

		/// <summary>
		/// The absolution path (server side) of the user files directory. It 
		/// is based on the <see cref="FileWorkerBase.UserFilesPath"/>.
		/// </summary>
		protected string UserFilesDirectory
		{
			get	
			{
				if ( sUserFilesDirectory == null )
				{
					// Get the local (server) directory path translation.
					sUserFilesDirectory = Server.MapPath( this.UserFilesPath ) ;
				}
				return sUserFilesDirectory ;
			}
		}
	}
}
