﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Dialog windows operations.
 */

var FCKDialog =
{
	_BaseZIndex : FCKConfig.FloatingPanelsZIndex + 1,
	_DialogStack : [],
	LastSelectionData : null
} ;

// This method opens a dialog window using the standard dialog template.
FCKDialog.OpenDialog = function( dialogName, dialogTitle, dialogPage, width, height, customValue, parentWindow, resizable )
{
	// Setup the dialog info.
	var dialogInfo =
	{
		Title : dialogTitle,
		Page : dialogPage,
		Editor : window,
		CustomValue : customValue,		// Optional
		SelectionData : null
	}

	if ( FCKBrowserInfo.IsIE )
	{
		var oSel = FCK.ToolbarSet.CurrentInstance.EditorDocument.selection ;
		var bInvalidRange = false ;

		if ( !oSel )
			bInvalidRange = true ;

		var oRange = oSel.createRange() ;
		if ( !oRange )
			bInvalidRange = true ;
		if ( oRange.parentElement && oRange.parentElement().ownerDocument != FCK.ToolbarSet.CurrentInstance.EditorDocument )
			bInvalidRange = true ;
		if ( oRange.item && oRange.item(0).ownerDocument != FCK.ToolbarSet.CurrentInstance.EditorDocument )
			bInvalidRange = true ;

		if ( bInvalidRange )
			dialogInfo.SelectionData = this.LastSelectionData ;
		else
		{
			dialogInfo.SelectionData = oRange ;
			this.LastSelectionData = oRange ;
		}
	}

	var url = FCKConfig.BasePath + 'fckdialog.html' ;
	this.Show( dialogInfo, dialogName, url, width, height, parentWindow, resizable ) ;
}

FCKDialog.Show = function( dialogInfo, dialogName, pageUrl, dialogWidth, dialogHeight, parentWindow, resizable )
{
	var ownerWindow = FCK.ToolbarSet.CurrentInstance.Window.parent ;
	var ownerDocument = ownerWindow.document ;

	var viewSize = FCKTools.GetViewPaneSize( ownerWindow ) ;
	var scrollPosition = FCKTools.GetScrollPosition( ownerWindow ) ;

	// Calculate the dialog position, centering it on the screen.
	var iTop  = Math.max( scrollPosition.Y + ( viewSize.Height - dialogHeight - 20 ) / 2, 0 ) ;
	var iLeft = Math.max( scrollPosition.X + ( viewSize.Width - dialogWidth - 20 )  / 2, 0 ) ;

	var frame = ownerDocument.createElement( 'iframe' ) ;
	frame.frameBorder = 0 ;
	frame.allowTransparency = true ;
	FCKDomTools.SetElementStyles( frame,
			{
				'position' : 'absolute',
				'top' : iTop + 'px',
				'left' : iLeft + 'px',
				'zIndex' : this._BaseZIndex += 100
			} ) ;

	// Save the dialog info to be used by the dialog page once loaded.
	frame._DialogArguments = dialogInfo ;

	ownerDocument.body.appendChild( frame ) ;
	this.ResizeDialog( frame, dialogWidth, dialogHeight ) ;
	
	// Assigning frame.src directly does not work in Opera 9.5, need to use a timeout trick
	setTimeout( function()
		{
			frame.src = pageUrl ;
		}, 0 ) ;

	var oWindow = this.Window = frame.contentWindow ;
	oWindow.focus() ;

	// Keep record of the current dialog in the dialog stack, and enable dialog mode
	// if this is the first dialog in the dialog stack.
	if ( this._DialogStack.length == 0 )
		FCK.ToolbarSet.CurrentInstance.SetDialogMode( true ) ;
	else
		this.SetEnabled( this._DialogStack[ this._DialogStack.length - 1 ], false );
	this._DialogStack.push( frame ) ;

	// Register drag handlers.
	this.InitDragHandlers( ownerWindow ) ;
}

// The following member functions should be called with a dialog frame element as subject.
FCKDialog.ResizeDialog = function( frame, width, height )
{
	FCKDomTools.SetElementStyles( frame,
		{
			'width' : width + 'px',
			'height' : height + 'px'
		} ) ;
}

FCKDialog.CloseDialog = function( frame )
{
	frame.parentNode.removeChild( frame ) ;
	
	this._BaseZIndex -= 100 ;

	// Pop the dialog from the dialog stack, and disable dialog mode if the stack is empty.
	this._DialogStack.pop() ;
	if ( this._DialogStack.length == 0)
		FCK.ToolbarSet.CurrentInstance.SetDialogMode( false ) ;
	else
		this.SetEnabled( this._DialogStack[ this._DialogStack.length - 1 ], true ) ;

}

FCKDialog.SetEnabled = function( frame, isEnabled )
{
	var doc = frame.contentWindow.document ;
	var cover = doc.getElementById( 'cover' ) ;
	cover.style.display = isEnabled ? 'none' : '' ;

	var isIE6 = FCKBrowserInfo.IsIE && !FCKBrowserInfo.IsIE7;

	if ( isIE6 )
	{
		if ( !isEnabled )
		{
			// Insert the blocker IFRAME before the cover.
			var blocker = doc.createElement( 'iframe' ) ;
			blocker.src = 'javascript:void(0)' ;
			blocker.hideFocus = true ;
			blocker.frameBorder = 0 ;
			blocker.id = blocker.className = 'blocker' ;

			doc.body.insertBefore( blocker, cover ) ;
		}
		else
		{
			var blocker = doc.getElementById( 'blocker' ) ;
			if ( blocker && blocker.parentNode )
				blocker.parentNode.removeChild( blocker ) ;
		}
	}
}

;(function()
{
	var _dragDialog = null ;
	var _ownerWindow = null ;
	var _lastCoords = null ;

	FCKDialog._GetMouseCoordinates = function( evt )
	{
		var element = evt.srcElement || evt.target ;
		var doc = FCKTools.GetElementDocument( element ) ;
		var view = doc.parentWindow || evt.view ;
		var retval = { 'x': evt.clientX, 'y': evt.clientY };

		if ( view != _ownerWindow )
		{
			var offset = FCKTools.GetDocumentPosition( _ownerWindow, doc.documentElement ) ;
			retval.x += offset.x ;
			retval.y += offset.y ;
		}

		return retval ;
	}

	FCKDialog._DragMouseDownHandler = function( evt )
	{
		var view = null ;
		if ( !evt )
		{
			view = FCKTools.GetElementDocument( this ).parentWindow ;
			evt = view.event ;
		}
		else
			view = evt.view ;

		_dragDialog = view.frameElement ;
		_lastCoords = FCKDialog._GetMouseCoordinates( evt ) ;

		if ( evt.preventDefault )
			evt.preventDefault() ;
		else
			evt.returnValue = false ;
	}

	FCKDialog._DragMouseMoveHandler = function( evt )
	{
		if ( !_dragDialog )
			return ;
		if ( !evt )
			evt = FCKTools.GetElementDocument( this ).parentWindow.event ;

		var currentCoords = FCKDialog._GetMouseCoordinates( evt );
		var dx = currentCoords.x - _lastCoords.x;
		var dy = currentCoords.y - _lastCoords.y;
		_lastCoords = currentCoords;

		var x = parseInt( FCKDomTools.GetCurrentElementStyle( _ownerWindow, _dragDialog, 'left' ) ) + dx ;
		var y = parseInt( FCKDomTools.GetCurrentElementStyle( _ownerWindow, _dragDialog, 'top' ) ) + dy ;
		FCKDomTools.SetElementStyles( _dragDialog,
			{
				'left' : x + 'px',
				'top' : y + 'px'
			} ) ;

		if ( evt.preventDefault )
			evt.preventDefault() ;
		else
			evt.returnValue = false ;
	}

	FCKDialog._DragMouseUpHandler = function( evt )
	{
		if ( !_dragDialog )
			return ;
		if ( !evt )
			evt = FCKTools.GetElementDocument( this ).parentWindow.event ;
		_dragDialog = null ;
		_lastCoords = null ;
	}

	FCKDialog.RegisterDragHandlers = function( w )
	{
		if ( w._FCKDialogHandlersRegistered )
			return ;

		FCKTools.AddEventListener( w.document.documentElement, 'mousemove', this._DragMouseMoveHandler ) ;
		FCKTools.AddEventListener( w.document.documentElement, 'mouseup', this._DragMouseUpHandler ) ;
		w._FCKDialogHandlersRegistered = true ;
	}

	FCKDialog.InitDragHandlers = function( w )
	{
		if ( _ownerWindow )
			return ;
		_ownerWindow = w ;
		this.RegisterDragHandlers( w ) ;
	}
})() ;
