﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Dialog windows operations.
 */

var FCKDialog =
{
	_BaseZIndex : FCKConfig.FloatingPanelsZIndex + 1,
	TopDialog : null,
	LastSelectionData : null
} ;

// This method opens a dialog window using the standard dialog template.
FCKDialog.OpenDialog = function( dialogName, dialogTitle, dialogPage, width, height, customValue, parentWindow, resizable )
{
	// Setup the dialog info.
	var dialogInfo =
	{
		Title : dialogTitle,
		Page : dialogPage,
		Editor : window,
		CustomValue : customValue,		// Optional
		SelectionData : null
	}

	if ( FCKBrowserInfo.IsIE )
	{
		var oSel = FCK.ToolbarSet.CurrentInstance.EditorDocument.selection ;
		var bInvalidRange = false ;

		if ( !oSel )
			bInvalidRange = true ;

		var oRange = oSel.createRange() ;
		if ( !oRange )
			bInvalidRange = true ;
		if ( oRange.parentElement && oRange.parentElement().ownerDocument != FCK.ToolbarSet.CurrentInstance.EditorDocument )
			bInvalidRange = true ;
		if ( oRange.item && oRange.item(0).ownerDocument != FCK.ToolbarSet.CurrentInstance.EditorDocument )
			bInvalidRange = true ;

		if ( bInvalidRange )
			dialogInfo.SelectionData = this.LastSelectionData ;
		else
		{
			dialogInfo.SelectionData = oRange ;
			this.LastSelectionData = oRange ;
		}
	}

	var url = FCKConfig.BasePath + 'fckdialog.html' ;
	var ownerWindow = FCK.ToolbarSet.CurrentInstance.Window.parent ;
	var ownerDocument = ownerWindow.document ;

	var viewSize = FCKTools.GetViewPaneSize( ownerWindow ) ;
	var scrollPosition = FCKTools.GetScrollPosition( ownerWindow ) ;

	// Calculate the dialog position, centering it on the screen.
	var iTop  = Math.max( scrollPosition.Y + ( viewSize.Height - height - 20 ) / 2, 0 ) ;
	var iLeft = Math.max( scrollPosition.X + ( viewSize.Width - width - 20 )  / 2, 0 ) ;

	var dialog = ownerDocument.createElement( 'iframe' ) ;
	dialog.frameBorder = 0 ;
	dialog.allowTransparency = true ;
	FCKDomTools.SetElementStyles( dialog,
			{
				'position' : 'absolute',
				'top' : iTop + 'px',
				'left' : iLeft + 'px',
				'zIndex' : this._BaseZIndex += 100
			} ) ;

	// Save the dialog info to be used by the dialog page once loaded.
	dialog._DialogArguments = dialogInfo ;

	ownerDocument.body.appendChild( dialog ) ;
	FCKDomTools.SetElementStyles( dialog,
			{
				'width' : width + 'px',
				'height' : height + 'px'
			} ) ;

	// Assigning dialog.src directly does not work in Opera 9.5, need to use a timeout trick
	setTimeout( function()
		{
			dialog.src = url ;
		}, 0 ) ;

	var oWindow = dialog.contentWindow ;
	oWindow.focus() ;

	// Keep record of the dialog's parent/child relationships.
	dialog._ParentDialog = this.TopDialog ;
	this.TopDialog = dialog ;
}
