/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package com.fredck.fckeditor.tool;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Compatibility check.
 *
 * @version $Id: Compatibility.java 1187 2008-01-03 19:09:23Z th-schwarz $
 * @author <a href="mailto:th-schwarz@users.sourceforge.net">Thilo Schwarz</a>
 */
public class Compatibility {

    /**
     * Checks, if a browser's user agent string is compatible for the FCKeditor.
     * 
     * @param userAgentString
     * @return true, if compatible
     */
    public static boolean check(final String userAgentString) {
        if (userAgentString == null || userAgentString.length() < 1)
            return false;
    
        float version;
    
        // IE 5.5+, check 'Opera' because Opera 8.5 contains 'MSIE' in its user
        // agent string!
        version = getBrowserVersion(userAgentString, ".*MSIE ([\\d]+.[\\d]+).*");
        if (userAgentString.indexOf("Opera") < 0 && version != -1f
        	&& version >= 5.5f)
            return true;
    
        // Gecko
        version = getBrowserVersion(userAgentString, ".*Gecko/([\\d]+).*");
        if (version != -1f && version >= 20030210f)
            return true;
    
        // Opera 9+
        version = getBrowserVersion(userAgentString, "Opera/([\\d]+.[\\d]+).*");
        if (version != -1f && version >= 9.0f)
            return true;
    
        // Safari 3+
        version = getBrowserVersion(userAgentString, ".*AppleWebKit/([\\d]+).*");
        if (version != -1f && version >= 522f)
            return true;
    
        return false;
    }

    /**
     * Helper method to get the the browser version from 'userAgent' with the
     * regular expression 'regex'. The first group of the matches has to be the
     * version number!
     * 
     * @param userAgent
     * @param regex
     * @return The browser version, or -1f
     */
    private static float getBrowserVersion(final String userAgent,
            final String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.matches()) {
            try {
        	return Float.parseFloat(matcher.group(1));
            } catch (NumberFormatException e) {
            }
        }
        return -1f;
    }

}
