/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package com.fredck.fckeditor;

/**
 * Static handler object, which provides getters and setters for basic values like fckeditor dir, base dir (user dir)
 * and defaults for height, width and toolbar of the editor. All values are preset by the defaults defined in
 * default.properties. This object is used everywhere these values are needed. <br />
 * If the {@link IBaseDirProvider} is set, {@link #getBaseDir()} is calling {@link IBaseDirProvider#getDir()} to get the
 * user dir.
 * 
 * @version $Id:ConfigurationHandler.java 1099 2007-11-06 15:01:50Z th-schwarz $
 */
public class ConfigurationHandler {
    private static String baseDir;

    private static IBaseDirProvider baseDirProvider = null;

    private static String fckEditorDir;

    private static String fckEditorHeight;

    private static String fckEditorWidth;

    private static String fckEditorToolbarSet;

    static {
	// load defaults
	baseDir = DefaultPropertiesHolder.get("fckeditor.basedir");
	fckEditorDir = DefaultPropertiesHolder.get("fckeditor.dir");
	fckEditorWidth = DefaultPropertiesHolder.get("fckeditor.width");
	fckEditorHeight = DefaultPropertiesHolder.get("fckeditor.height");
	fckEditorToolbarSet = DefaultPropertiesHolder.get("fckeditor.toolbarset");
    }

    /**
     * Getter for the base dir (using for user files).
     * 
     * @return If the {@link IBaseDirProvider} is set, then it's dir getter is called, or base dir.
     */
    public static String getBaseDir() {
	return (baseDirProvider != null) ? baseDirProvider.getDir() : baseDir;
    }

    /**
     * Setter for the base dir (using for user files).
     * 
     * @param baseDir
     *                relative to the context root (no leading or ending /).
     */
    public static void setBaseDir(final String baseDir) {
	ConfigurationHandler.baseDir = baseDir;
    }

    /**
     * Getter for the {@link IBaseDirProvider}.
     * 
     * @param baseDirProvider
     */
    public static void setBaseDirProvider(final IBaseDirProvider baseDirProvider) {
	ConfigurationHandler.baseDirProvider = baseDirProvider;
    }

    /**
     * Getter for the dir of the fckeditor.
     * 
     * @return Dir of the fckeditor relative to the context root.
     */
    public static String getFckEditorDir() {
	return fckEditorDir;
    }

    /**
     * Setter for the dir of the fckeditor.
     * 
     * @param fckEditorDir
     *                relative to the context root (no leading or ending /).
     */
    public static void setFckEditorDir(final String fckEditorDir) {
	ConfigurationHandler.fckEditorDir = fckEditorDir;
    }

    /**
     * Getter for the default height of the fckeditor.
     * 
     * @return Default height of the fckeditor.
     */
    public static String getFckEditorHeight() {
	return fckEditorHeight;
    }

    /**
     * Setter for the default height of the fckeditor.
     * 
     * @param fckEditorHeight
     *                the default height of the fckeditor.
     */
    public static void setFckEditorHeight(final String fckEditorHeight) {
	ConfigurationHandler.fckEditorHeight = fckEditorHeight;
    }

    /**
     * Getter for the default width of the fckeditor.
     * 
     * @return Default width of the fckeditor.
     */
    public static String getFckEditorWidth() {
	return fckEditorWidth;
    }

    /**
     * Setter for the default width of the fckeditor.
     * 
     * @param fckEditorWidth
     *                the default width of the fckeditor.
     */
    public static void setFckEditorWidth(final String fckEditorWidth) {
	ConfigurationHandler.fckEditorWidth = fckEditorWidth;
    }

    /**
     * Getter of the name of the default toolbarset of the fckeditor.
     * 
     * @return Name of the default toolbar set.
     */
    public static String getFckEditorToolbarSet() {
	return fckEditorToolbarSet;
    }

    /**
     * Getter of the name of the default toolbarset of the fckeditor.
     * 
     * @param fckEditorToolbarSet
     *                the name of the toolbarset.
     */
    public static void setFckEditorToolbarSet(final String fckEditorToolbarSet) {
	ConfigurationHandler.fckEditorToolbarSet = fckEditorToolbarSet;
    }
}
