/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package com.fredck.fckeditor.uploader;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;

import com.fredck.fckeditor.ConfigurationHandler;
import com.fredck.fckeditor.Constants;
import com.fredck.fckeditor.ExtensionsHandler;
import com.fredck.fckeditor.connector.ConnectorServlet;
import com.fredck.fckeditor.tool.Utils;

/**
 * Servlet to upload files.<br>
 * 
 * This servlet accepts just file uploads, eventually with a parameter
 * specifying file type
 * 
 * @version $Id:SimpleUploaderServlet.java 1099 2007-11-06 15:01:50Z th-schwarz $
 * @see ConnectorServlet
 * @deprecated wird laut 2.5 spec vom doPost des connectorservlets erledigt
 */
@Deprecated
public class SimpleUploaderServlet extends HttpServlet {

    private static boolean debug = false;
    private static boolean enabled = false;

    /**
     * Initialize the servlet.<br>
     * Retrieve from the servlet configuration the "baseDir" which is the root
     * of the file repository:<br>
     * Also it retrieve all allowed and denied extensions to be handled.
     */
    public void init() throws ServletException {
	debug = Boolean.getBoolean(getInitParameter("debug")); 
	if (debug)
	    System.out
		    .println("\r\n---- SimpleUploaderServlet initialization started ----");

	if (getInitParameter("baseDir") != null)
	    ConfigurationHandler.setBaseDir(getInitParameter("baseDir"));
	String realBaseDir = getServletContext().getRealPath("/" +
		ConfigurationHandler.getBaseDir() + "/");
	File baseFile = new File(realBaseDir);
	if (!baseFile.exists()) {
	    baseFile.mkdirs();
	}
	
	ExtensionsHandler.setExtensionsAllowed(Constants.FILE_TYPE_FILE, getInitParameter("AllowedExtensionsFile"));
	ExtensionsHandler.setExtensionsDenied(Constants.FILE_TYPE_FILE, getInitParameter("DeniedExtensionsFile"));

	ExtensionsHandler.setExtensionsAllowed(Constants.FILE_TYPE_IMAGE, getInitParameter("AllowedExtensionsImage"));
	ExtensionsHandler.setExtensionsDenied(Constants.FILE_TYPE_IMAGE, getInitParameter("DeniedExtensionsImage"));

	ExtensionsHandler.setExtensionsAllowed(Constants.FILE_TYPE_FLASH, getInitParameter("AllowedExtensionsFlash"));
	ExtensionsHandler.setExtensionsDenied(Constants.FILE_TYPE_FLASH, getInitParameter("DeniedExtensionsFlash"));

	if (debug)
	    System.out
		    .println("---- SimpleUploaderServlet initialized ----");

    }

    /**
     * Manage the Upload requests.<br>
     * 
     * The servlet accepts commands sent in the following format:<br>
     * simpleUploader?Type=ResourceType<br>
     * <br>
     * It store the file (renaming it in case a file with the same name exists)
     * and then return an HTML file with a javascript command in it.
     * 
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response)
	    throws ServletException, IOException {

	if (debug)
	    System.out.println("--- BEGIN DOPOST ---");

	response.setContentType("text/html; charset=UTF-8");
	response.setHeader("Cache-Control", "no-cache");
	PrintWriter out = response.getWriter();

	String typeStr = request.getParameter("Type");

	String currentPath = "/" + ConfigurationHandler.getBaseDir() + "/" + typeStr;
	currentPath = Utils.replaceAll(currentPath, "//", "/");
	String currentDirPath = getServletContext().getRealPath(currentPath);
	currentPath = request.getContextPath() + currentPath;

	if (debug)
	    System.out.println(currentDirPath);

	String retVal = "0";
	String newName = "";
	String fileUrl = "";
	String errorMessage = "";

	if (enabled) {
	    FileItemFactory factory = new DiskFileItemFactory();
	    ServletFileUpload upload = new ServletFileUpload(factory);
	    try {
		List items = upload.parseRequest(request);

		Map fields = new HashMap();

		Iterator iter = items.iterator();
		while (iter.hasNext()) {
		    FileItem item = (FileItem) iter.next();
		    if (item.isFormField())
			fields.put(item.getFieldName(), item.getString());
		    else
			fields.put(item.getFieldName(), item);
		}
		FileItem uplFile = (FileItem) fields.get("NewFile");
		String fileNameLong = uplFile.getName();
		fileNameLong = fileNameLong.replace('\\', '/');
		String[] pathParts = fileNameLong.split("/");
		String fileName = pathParts[pathParts.length - 1];

		String nameWithoutExt = FilenameUtils.getBaseName(fileName);
		String ext = FilenameUtils.getExtension(fileName);
		File pathToSave = new File(currentDirPath, fileName);
		fileUrl = currentPath + "/" + fileName;
		if (ExtensionsHandler.isAllowed(typeStr, ext)) {
		    int counter = 1;
		    while (pathToSave.exists()) {
			newName = nameWithoutExt + "(" + counter + ")" + "."
				+ ext;
			fileUrl = currentPath + "/" + newName;
			retVal = "201";
			pathToSave = new File(currentDirPath, newName);
			counter++;
		    }
		    uplFile.write(pathToSave);
		} else {
		    retVal = "202";
		    errorMessage = "";
		    if (debug)
			System.out.println("Invalid file type: " + ext);
		}
	    } catch (Exception ex) {
		if (debug)
		    ex.printStackTrace();
		retVal = "203";
	    }
	} else {
	    retVal = "1";
	    errorMessage = "This file uploader is disabled. Please check the WEB-INF/web.xml file";
	}

	out.println("<script type=\"text/javascript\">");
	out.println("window.parent.OnUploadCompleted(" + retVal + ",'"
		+ fileUrl + "','" + newName + "','" + errorMessage + "');");
	out.println("</script>");
	out.flush();
	out.close();

	if (debug)
	    System.out.println("--- END DOPOST ---");

    }
}
