<!-- @Packager.Header
<FileDescription>
	This file include IO specific functions used by the ASP Connector.
</FileDescription>
<Author name="Frederico Caldeira Knabben" email="www.fckeditor.net" />
-->
<%
Function GetUrlFromPath( resourceType, folderPath )
	If resourceType = "" Then
		GetUrlFromPath = RemoveFromEnd( sUserFilesPath, "/" ) & folderPath
	Else
		GetUrlFromPath = sUserFilesPath & LCase( resourceType ) & folderPath
	End If
End Function

Function RemoveExtension( fileName )
	RemoveExtension = Left( fileName, InStrRev( fileName, "." ) - 1 )
End Function

Function ServerMapFolder( resourceType, folderPath )
	' Get the resource type directory.
	Dim sResourceTypePath
	sResourceTypePath = sUserFilesDirectory & LCase( resourceType ) & "\"
	
	' Ensure that the directory exists.
	CreateServerFolder sResourceTypePath

	' Return the resource type directory combined with the required path.
	ServerMapFolder = sResourceTypePath & RemoveFromStart( folderPath, "/" )
End Function

Sub CreateServerFolder( folderPath )
	Dim oFSO
	Set oFSO = Server.CreateObject( "Scripting.FileSystemObject" )
	
	Dim sParent
	sParent = oFSO.GetParentFolderName( folderPath )
	
	' Check if the parent exists, or create it.
	If ( NOT oFSO.FolderExists( sParent ) ) Then CreateServerFolder( sParent )
	
	If ( oFSO.FolderExists( folderPath ) = False ) Then 
		oFSO.CreateFolder( folderPath )
	End If
	
	Set oFSO = Nothing
End Sub

Function IsAllowedExt( extension, resourceType )
	Dim oRE
	Set oRE	= New RegExp
	oRE.IgnoreCase	= True
	oRE.Global		= True
	
	Dim sAllowed, sDenied
	sAllowed	= ConfigAllowedExtensions.Item( resourceType )
	sDenied		= ConfigDeniedExtensions.Item( resourceType )
	
	IsAllowedExt = True
	
	If sDenied <> "" Then
		oRE.Pattern	= sDenied
		IsAllowedExt	= Not oRE.Test( extension )
	End If 
	
	If IsAllowedExt And sAllowed <> "" Then
		oRE.Pattern		= sAllowed
		IsAllowedExt	= oRE.Test( extension )
	End If
	
	Set oRE	= Nothing
End Function
%>