/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */

package com.fredck.fckeditor;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * Contains the configuration settings for the FCKEditor.<br>
 * Adding element to this collection you can override the settings specified in
 * the config.js file.
 * 
 * @version $Id: FCKeditorConfigurations.java 1312 2008-01-14 22:41:41Z mosipov $
 */
public class FCKeditorConfigurations extends HashMap {

    /**
     * Initialize the configuration collection
     */
    public FCKeditorConfigurations() {
	super();
    }

    /**
     * Generate the url parameter sequence used to pass this configuration to
     * the editor.
     * 
     * @return html endocode sequence of configuration parameters
     */
    public String getUrlParams() {
	StringBuffer osParams = new StringBuffer();

	for (Iterator i = this.entrySet().iterator(); i.hasNext();) {
	    Map.Entry entry = (Map.Entry) i.next();
	    if (entry.getValue() != null) {
		osParams.append("&");
		osParams.append(encodeConfig(entry.getKey().toString()));
		osParams.append("=");
		osParams.append(encodeConfig(entry.getValue().toString()));
	    }
	}
	return osParams.toString();
    }

    /**
     * @see URLEncoder#encode(String, String)
     * @param txt
     * @return
     */
    @Deprecated
    private String encodeConfig(String txt) {
	txt = txt.replaceAll("&", "%26");
	txt = txt.replaceAll("=", "%3D");
	txt = txt.replaceAll("\"", "%22");
	return txt;
    }

}
