/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.tool;

import static org.junit.Assert.assertTrue;

import java.util.HashSet;
import java.util.Set;

import org.junit.Test;

/**
 * Tests for {@link Utils#getSet(String, String)}.
 *
 * @version $Id: Util_getSet.java 1184 2008-01-03 10:39:36Z th-schwarz $
 * @author <a href="mailto:th-schwarz@users.sourceforge.net">Thilo Schwarz</a>
 */
public class Util_getSet {

    @Test
    public void test_getSet01() throws Exception {
	Set<String> set = new HashSet<String>();
	set.add("a");
	set.add("ab");
	set.add("c");
	
	Set<String> newSet = Utils.getSet("a|Ab|c", "|");
	for (String string : newSet) {
	    assertTrue(set.contains(string));
	}
    }
    
    @Test
    public void test_getSet02() throws Exception {
	Set<String> set = new HashSet<String>();
	set.add("png");
	set.add("jpg");
	set.add("gif");
	
	Set<String> newSet = Utils.getSet("png|jpg|gif");
	for (String string : newSet) {
	    assertTrue(set.contains(string));
	}
    }
}
