/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.tool;

import static org.junit.Assert.*;

import org.junit.Test;

/**
 * Tests for {@link Utils#replaceAll(String, String, String)};
 *
 * @version $Id: Util_replace.java 1184 2008-01-03 10:39:36Z th-schwarz $
 * @author <a href="mailto:th-schwarz@users.sourceforge.net">Thilo Schwarz</a>
 */
public class Utils_replace {

    @Test
    public void test_replace01() {
	String str =  Utils.replaceAll("//a/b//c", "//", "/");
	assertEquals(str, "/a/b/c");
    }

    @Test
    public void test_replace02() {
	String str = Utils.replaceAll(null, "a", "c");
	assertEquals(str, "");
    }

    @Test
    public void test_replace03() {
	String str = Utils.replaceAll("foo", null, "c");
	assertEquals(str, "foo");
    }

    @Test
    public void test_replace04() {
	String str = Utils.replaceAll("foo", "o", "a");
	assertEquals(str, "faa");
    }
}
