/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.tool;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.HashSet;
import java.util.Set;

import org.junit.Test;

/**
 * Tests for {@link Utils};
 * 
 * @version $Id$
 * @author <a href="mailto:th-schwarz@users.sourceforge.net">Thilo Schwarz</a>
 */
public class UtilsTest {

	@Test
	public void getSet01() {
		Set<String> set = new HashSet<String>();
		set.add("a");
		set.add("ab");
		set.add("c");

		Set<String> newSet = Utils.getSet("a|Ab|c", "|");
		for (String string : newSet) {
			assertTrue(set.contains(string));
		}
	}

	@Test
	public void getSet02() {
		Set<String> set = new HashSet<String>();
		set.add("png");
		set.add("jpg");
		set.add("gif");

		Set<String> newSet = Utils.getSet("png|jpg|gif");
		for (String string : newSet) {
			assertTrue(set.contains(string));
		}
	}

	@Test
	public void replaceAll01() {
		String str = Utils.replaceAll("//a/b//c", "//", "/");
		assertEquals(str, "/a/b/c");
	}

	@Test
	public void replaceAll02() {
		String str = Utils.replaceAll(null, "a", "c");
		assertEquals(str, "");
	}

	@Test
	public void replaceAll03() {
		String str = Utils.replaceAll("foo", null, "c");
		assertEquals(str, "foo");
	}

	@Test
	public void replaceAll04() {
		String str = Utils.replaceAll("foo", "o", "a");
		assertEquals(str, "faa");
	}
}
