package net.fckeditor.tool;

import java.util.LinkedHashMap;
import java.util.Map;

public class UploadResponse {

	private Map<String, String> parameters;
	public static final int EN_OK = 0;
	public static final int EN_ERROR = 1;
	public static final int EN_WARNING = 101;
	public static final int EN_RENAMED = 201;
	public static final int EN_INVALID_EXTENSION = 202;
	public static final int EN_SECURITY_ERROR = 203;
	public static final int EN_GENERIC_NUMBER = -1;
	
	public static final UploadResponse UR_OK = new UploadResponse(EN_OK);
	public static final UploadResponse UR_INVALID_EXTENSION = new UploadResponse(EN_INVALID_EXTENSION);
	public static final UploadResponse UR_SECURITY_ERROR = new UploadResponse(EN_SECURITY_ERROR);
	public static final UploadResponse UR_GENERIC_NUMBER = new UploadResponse(EN_GENERIC_NUMBER);

	public UploadResponse(int errorNumber, String fileUrl, String filename,
			String customMessage) {
		parameters = new LinkedHashMap<String, String>(4);
		parameters.put("errorNumber", String.valueOf(errorNumber));
		parameters.put("fileUrl", fileUrl);
		parameters.put("fileyname", filename);
		parameters.put("customMessage", customMessage);
	}

	public UploadResponse(int errorNumber) {
		parameters = new LinkedHashMap<String, String>(1);
		parameters.put("errorNumber", String.valueOf(errorNumber));
	}

	/**
	 * 
	 * @param filename
	 */
	public void setFilename(String filename) {
		if (parameters.size() == 1)
			parameters.put("fileUrl", null);
		parameters.put("filename", filename);
	}

	public void setCustomMessage(String customMassage) {
		if (parameters.size() == 1) {
			parameters.put("fileUrl", null);
			parameters.put("filename", null);
		}
		parameters.put("customMessage", customMassage);
	}

	public void setErrorNumber(int errorNumber) {
		parameters.put("errorNumber", String.valueOf(errorNumber));
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(75);
		sb.append("<script type=\"text/javascript\">\n");
		sb.append("window.parent.OnUploadCompleted(");

		if (parameters.size() == 1) {
			sb.append(parameters.get("errorNumber"));
		} else {
			for (String parameter : parameters.values()) {
				
				if (Utils.isNotEmpty(parameter)) {
					if (parameter.matches("-?\\d{1,3}")) {
						sb.append(parameter);
					} else {
					sb.append("'");
					sb.append(parameter);
					sb.append("'");
					}
				}
				sb.append(",");
				
				
			}
			sb.deleteCharAt(sb.length() - 1);
		}

		sb.append(");\n");
		sb.append("</script>");

		return sb.toString();
	}

	public static void main(String[] args) {

		UploadResponse ur = new UploadResponse(101);
		//ur.setCustomMessage("shit happens");
		//ur.setFilename("hacked.php");
		ur.setCustomMessage("nothing happens");
		System.out.println(ur);
	}
}
