package net.fckeditor.tool;

import java.util.LinkedHashMap;
import java.util.Map;

public class UploadResponse {

	private Map<String, String> parameters;

	// TODO Rename 'En_'-constants to something more intuitive like 'CODE_'
	public static final int EN_OK = 0;
	public static final int EN_ERROR = 1;
	public static final int EN_WARNING = 101;
	public static final int EN_RENAMED = 201;
	public static final int EN_INVALID_EXTENSION = 202;
	public static final int EN_SECURITY_ERROR = 203;
	public static final int EN_GENERIC_NUMBER = -1;

	public static final String CM_HTTP_400 = "400 Bad request";

	// public static final UploadResponse UR_OK = new UploadResponse(EN_OK);
	public static final UploadResponse UR_INVALID_EXTENSION = new UploadResponse(EN_INVALID_EXTENSION);
	public static final UploadResponse UR_SECURITY_ERROR = new UploadResponse(EN_SECURITY_ERROR);
	public static final UploadResponse UR_GENERIC_NUMBER = new UploadResponse(EN_GENERIC_NUMBER);

	public UploadResponse(int errorNumber, final String fileUrl, final String filename, final String customMessage) {
		parameters = new LinkedHashMap<String, String>(); // we must respect the order of the params!
		setErrorNumber(errorNumber);
		if (fileUrl != null)
			parameters.put("fileUrl", fileUrl);
		if (filename != null)
			setFilename(filename);
		if (customMessage != null)
			setCustomMessage(customMessage);
	}

	public UploadResponse(int errorNumber, final String fileUrl, final String filename) {
		this(errorNumber, fileUrl, filename, null);
	}

	public UploadResponse(int errorNumber, final String fileUrl) {
		this(errorNumber, fileUrl, null, null);
	}

	public UploadResponse(int errorNumber) {
		this(errorNumber, null, null, null);
	}

	public void setFilename(final String filename) {
		if (Utils.isNotEmpty(filename)) {
			if (parameters.size() == 1)
				parameters.put("fileUrl", null);
			parameters.put("filename", filename);
		}
	}

	public void setCustomMessage(final String customMassage) {
		if (Utils.isNotEmpty(customMassage)) {
			if (parameters.size() == 1) {
				parameters.put("fileUrl", null);
				parameters.put("filename", null);
			}
			parameters.put("customMessage", customMassage);
		}
	}

	public void setErrorNumber(int errorNumber) {
		parameters.put("errorNumber", String.valueOf(errorNumber));
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(75);
		sb.append("<script type=\"text/javascript\">\n");
		sb.append("window.parent.OnUploadCompleted(");

		if (parameters.size() == 1) {
			sb.append(parameters.get("errorNumber"));
		} else {
			for (String parameter : parameters.values()) {

				if (Utils.isNotEmpty(parameter)) {
					if (parameter.matches("-?\\d{1,3}")) {
						sb.append(parameter);
					} else {
						sb.append("'");
						sb.append(parameter);
						sb.append("'");
					}
				} else {
					sb.append("'");
					sb.append("'");
				}
				sb.append(",");

			}
			sb.deleteCharAt(sb.length() - 1);
		}

		sb.append(");\n");
		sb.append("</script>");

		return sb.toString();
	}

	public static void main(String[] args) {

		UploadResponse ur = new UploadResponse(101);
		ur.setCustomMessage("shit happens");
		// ur.setFilename("test");
		// ur.setCustomMessage("nothing happens");
		System.out.println(ur);
	}
}
