/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.tool;

/**
 * 
 * @since 2.4
 * @version $Id$
 */
public class UploadResponse {

	private Object[] parameters;

	// TODO Rename 'En_'-constants to something more intuitive like 'CODE_'
	public static final int EN_OK = 0;
	public static final int EN_ERROR = 1;
	public static final int EN_WARNING = 101;
	public static final int EN_RENAMED = 201;
	public static final int EN_INVALID_EXTENSION = 202;
	public static final int EN_SECURITY_ERROR = 203;
	public static final int EN_GENERIC_NUMBER = -1;

	public static final String CM_HTTP_400 = "400 Bad request";

	public static final UploadResponse UR_INVALID_EXTENSION = new UploadResponse(
			EN_INVALID_EXTENSION);
	public static final UploadResponse UR_SECURITY_ERROR = new UploadResponse(
			EN_SECURITY_ERROR);
	public static final UploadResponse UR_GENERIC_NUMBER = new UploadResponse(
			EN_GENERIC_NUMBER);

	public UploadResponse(Object... arguments) throws IllegalArgumentException {
		if (arguments.length < 1 || arguments.length > 4)
			throw new IllegalArgumentException(
					"The amount of arguments has to be between 1 and 4");

		parameters = new Object[arguments.length];

		if (!(arguments[0] instanceof Integer))
			throw new IllegalArgumentException(
			"The first argument has to be an error number (int)");
			
		System.arraycopy(arguments, 0, parameters, 0, arguments.length);
	}

	public void setCustomMessage(final String customMassage) {
		if (Utils.isNotEmpty(customMassage)) {
			if (parameters.length == 1) {
				Object errorNumber = parameters[0];
				parameters = new Object[4];
				parameters[0] = errorNumber;
				parameters[1] = null;
				parameters[2] = null;
			}
			parameters[3] = customMassage;
		}
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(75);
		sb.append("<script type=\"text/javascript\">\n");
		sb.append("window.parent.OnUploadCompleted(");

		for (Object parameter : parameters) {
			if (parameter instanceof Integer) {
				sb.append(parameter);
			} else {
				sb.append("'");
				if (parameter != null)
					sb.append(parameter);
				sb.append("'");
			}
			sb.append(",");
		}
		
		sb.deleteCharAt(sb.length() - 1);
		sb.append(");\n");
		sb.append("</script>");

		return sb.toString();
	}
}
