package net.fckeditor.handlers;

import java.util.HashSet;
import java.util.Set;

public class TypeHandler {
	
	public static final String FILE = "File";  // the default
    public static final String IMAGE = "Image";
    public static final String FLASH = "Flash";
    public static final String MEDIA = "Media";
    
    private static Set<String> types = new HashSet<String>(4);
    
    static {
    	types.add(FILE);
    	types.add(IMAGE);
    	types.add(FLASH);
    	types.add(MEDIA);
    }
    
    public static boolean isValid(final String type) {
    	return types.contains(type);
    }
    
    public static String validate(final String type) {
    	if (isValid(type))
    		return type;
    	else return FILE;
    }

}
