/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.handlers;

import net.fckeditor.FileType;
import net.fckeditor.tool.Utils;

/**
 * Collection of little helper methods for {@link FileType}.
 * 
 * @version $Id: FileTypeHandler.java 1455 2008-02-01 19:59:38Z th-schwarz $
 */
public class FileTypeHandler {

	/**
	 * Finds the right {@link FileType} for a string representation. The case sensitifity of 'type'
	 * will be ignored.
	 * 
	 * @param type
	 * @return <code>null</code> if 'type' is unknown or null, otherwise {@link FileType}.
	 */
	public static FileType getType(final String type) {
		if (type == null)
			return null;
		for (FileType fileType : FileType.values()) {
			if (fileType.name().equalsIgnoreCase(type))
				return fileType;
		}
		return null;
	}

	/**
	 * Checks if 'type' is a string representation of {@link FileType}.
	 * 
	 * @param type
	 * @return
	 */
	public static boolean isValid(final String type) {
		return (getType(type) != null);
	}

	/**
	 * Just a wrapper to {@link #getType(String)}, but returns the default file type, if 'type' is unkown.
	 * 
	 * @param type
	 * @return
	 */
	public static FileType getTypeDefault(final String type) {
		FileType fileType = getType(type);
		return (fileType == null) ? FileType.FILE : fileType;
	}

	/**
	 * Getter for the sub dir name of a media type.<br>
	 * 
	 * Hint: Like  the path defaults in default.properties, the sub dir name starts with '/'.
	 * 
	 * @param type
	 * @return The sub dir name of the requested type, or the default one ('file') if 'type' is null
	 *         or the default value ist missing.
	 */
	public static String getSubDirForType(final FileType type) {
		String defaultSubDir = ConfigurationHandler
		        .getDefaultProperty("fckeditor.subdir.media.file");
		if (type == null)
			return defaultSubDir;
		String subDir = ConfigurationHandler.getDefaultProperty("fckeditor.subdir.media."
		        .concat(type.name().toLowerCase()));

		return (Utils.isEmpty(subDir)) ? defaultSubDir : subDir;
	}
}
